<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Country extends MX_Controller {

    function __construct() {
        $this->lang->load('admin');
        $this->load->model('Country_model', 'country');
        $this->load->model('Langs_model', 'slang');
        // Check if the logged user is an administrator
        $this->access_library->check_access();
    }

############################### items ################# 	

    public function showItems() {
        $data['arrs'] = $this->country->get_items();
        $this->system_library->load('country/item_list', $data, TRUE);
    }

    public function deleteItem() {
        $code = $this->uri->segment(4);
        $this->country->del_item($code);
        $this->session->set_flashdata('message', 'تم الحذف بنجاح');
        redirect('admin/country/showItems');
    }

    public function itemTpl() {
        $code = $this->uri->segment(4);
        if ($code) {
            $data['arr'] = $this->country->get_item($code);
            $data['folder'] = $this->country->folders();
            $this->system_library->load('country/item_tpl', $data, TRUE);
        } else {
            $this->system_library->load('country/item_tpl', $data, TRUE);
        }
    }

    public function addItem() {
        $code = $this->input->post('id');
        if ($code != '') {
            $this->country->edit_item($code);
        } else {
            $this->country->add_item();
        }
        //exit;
        $this->session->set_flashdata('message', 'تم الحفظ بنجاح');
        redirect('admin/country/showItems/' . $mktba_id);
    }

    public function download() {

        $id = $this->uri->segment(4);
        $query = $this->country->download($id);
        $dat = $query->row();
        $name = $dat->item_file;
        $path = "upload" . "/" . $dat->item_file;
//        var_dump($name);
//        exit();
        if (is_file($path)) {
            // required for IE
            if (ini_get('zlib.output_compression')) {
                ini_set('zlib.output_compression', 'Off');
            }
            // get the file mime type using the file extension
            $this->load->helper('file');
            $mime = get_mime_by_extension($path);
            // Build the headers to push out the file properly.
            header('Pragma: public');     // required
            header('Expires: 0');         // no cache
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s', filemtime($path)) . ' GMT');
            header('Cache-Control: private', false);
            header('Content-Type: ' . $mime);  // Add the mime type from Code igniter.
            header('Content-Disposition: attachment; filename="' . basename($name) . '"');  // Add the file name
            header('Content-Transfer-Encoding: binary');
            header('Content-Length: ' . filesize($path)); // provide file size
            header('Connection: close');
            readfile($path); // push it out
            exit();
        }
    }

}

######### end class 

    /* End of file welcome.php */
    /* Location: ./application/controllers/welcome.php */    