<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Messages extends MX_Controller {

    function __construct() {
        $this->lang->load('admin');
        $this->lang->load('home');
        $this->load->model('messages_model', 'messages');
        // Check if the logged user is an administrator
        $this->access_library->check_access();
    }

    //
    public function inbox_messages($type = 'from', $id = 0) {
        //var_dump($this->session->userdata('user_id'),$_SESSION);
        $data['type'] = $type;
        $data['messages'] = $this->messages->getMessages($type, $id);
        if ($id > 0) {
            $data['message'] = $data['messages'][0];
            $this->system_library->load('admin/messages/message_details', $data, TRUE);
        } else {
            //var_dump($data['messages']);
            $this->system_library->load('admin/messages/allMessages', $data, TRUE);
        }
    }

    public function send_message($to_id = 0) {
        $this->load->model('Users_model', 'user');
        $data['to_id'] = $to_id;
        $data['user'] = $this->user->get_user($this->session->userdata('user_id'));
        //var_dump($data['user']);
        if (count($_POST) && $_POST['send']) {
            //var_dump(($_POST));
            $this->messages->sendMessage();
            $this->session->set_flashdata('message', 'تم ارسال الرساله بنجاح');
            redirect('admin/messages/inbox_messages/to', 'refresh');
        } elseif (count($_POST) && $_POST['search'] && $this->session->userdata('level') == 1) {
            //var_dump(($_POST));
            //GET SCHOOLS
            $schools = array();
            $conditions = array('office' => $data['user']['office'], 'type1' => $_POST['type1'], 'educational_level' => $_POST['educational_level'], 'type2' => $_POST['type2']);
            $schools = $this->user->getUsers($conditions);
            //GET admin
            $conditions = array('level' => 2);
            $admin_user = $this->user->getUsers($conditions);
            //var_dump($admin_user[0]);
            $schools = is_array($schools) ? $schools : array();
            $data['users'] = array_merge($admin_user, $schools);
            //var_dump($data['users']);
            //redirect ( 'admin/messages/inbox_messages/', 'refresh' );
        } else {
            //var_dump($this->session->set_userdata('user_id'););
            $data['users'] = $this->messages->getUsers($data['user']['level']);
            //var_dump($data['users']);
        }
        $this->system_library->load('admin/messages/new_message', $data, TRUE);
    }

    public function deleteMessage($id = 0) {
        if (!$_SESSION['logged_in']) {
            redirect('home', 'refresh');
        }
        $this->messages->deleteMessage($id);
        $this->session->set_flashdata('message', ' تم الحذف بنجاح');
        redirect($_SERVER['HTTP_REFERER'], 'refresh');
    }

}

?>