<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Photos extends MX_Controller {

    function __construct() {

        $this->lang->load('admin');

        $this->load->model('Photos_model', 'photos');
        $this->load->model('Sites_model', 'sites');
        $this->load->model('Langs_model', 'slang');

        // Check if the logged user is an administrator

        $this->access_library->check_access();
    }

    ############################### cats ################# 	

    public function showCats() {

        $mktba_id = $this->uri->segment(4);

        //$data ['mktba'] = $this->photos->get_mktba ( $mktba_id );

        $data ['arrs'] = $this->photos->get_cats($mktba_id);

        $this->system_library->load('photos/cats_list', $data, TRUE);
    }

    public function deleteCats() {

        $mktba_id = $this->uri->segment(5);

        $this->photos->del_cats();

        $this->session->set_flashdata('message', 'تم الحذف بنجاح');

        redirect('admin/photos/showCats/' . $mktba_id);
    }

    public function catsTpl() {

        $edit = $this->uri->segment(6);

        $data ['cats'] = $this->photos->get_cats(7);

        $data ['langs'] = $this->slang->get_langs();

        $data['tmp'] = $this->photos->get_tmp();

        $data ['maxcode'] = $this->photos->max_code('cats_code', 'cat_photos');

        $code = $this->uri->segment(4);

        if ($edit) {

            $data ['arr'] = $this->photos->get_new($code);

            foreach ($data ['arr'] as $arr) {

                $data ['larr'] [$arr ['lang_abbr']] = $arr ['title'];

                $data ['darr'] [$arr ['lang_abbr']] = $arr ['description'];
            }

            $data ['maxcode'] = $data ['arr'] [0] ['cats_code'];

            $data ['mktba_id'] = $this->uri->segment(5);
        } else {

            $data ['arr'] = array();

            $data ['mktba_id'] = $this->uri->segment(4);
        }

        //$data ['mktba'] = $this->photos->get_mktba ( $data ['mktba_id'] );

        $this->system_library->load('photos/cats_tpl', $data, TRUE);
    }

    public function addCats() {

        $mktba_id = $this->input->post('mktba_id');

        //$data ['mktba'] = $this->photos->get_mktba ( $mktba_id );

        $code = $this->input->post('code');

        $title = $this->input->post('title');

        $description = $this->input->post('description');

        $lang_abbr = $this->input->post('lang_abbr');

        if ($code != '') {

            $this->photos->del_cats($code);
        }

        for ($i = 0; $i < count($lang_abbr); $i ++) {

            $this->photos->add_cats($lang_abbr [$i], $title [$i], $description[$i], $mktba_id);
        }

        $this->session->set_flashdata('message', 'تم الحفظ بنجاح');

        redirect('admin/photos/showCats/' . $mktba_id);
    }

    ############################### items ################# 	

    public function showItems() {
        //$data ['mktba'] = $this->photos->get_mktba ( $mktba_id );
        $data ['cats'] = $this->photos->get_country();
        $this->system_library->load('photos/item_list', $data, TRUE);
    }

    public function editItem() {
        $maxcode = $this->photos->max_code('item_code', 'photos');
        $item_name = $this->input->post('item_name');
        $item_details = $this->input->post('item_details');
        $lang_abbr = $this->input->post('lang_abbr');
        if ($_FILES['item_file']) {
            $_FILES['image']['name'] = $_FILES['item_file']['name'];
            $_FILES['image']['type'] = $_FILES['item_file']['type'];
            $_FILES['image']['tmp_name'] = $_FILES['item_file']['tmp_name'];
            $_FILES['image']['error'] = $_FILES['item_file']['error'];
            $_FILES['image']['size'] = $_FILES['item_file']['size'];
            $config['upload_path'] = 'upload/';
            $config['allowed_types'] = 'pdf|doc|ppt|zip|docx|xlsx|xls|avi|mp4|mp3|rmvb|avi|flv|wmv|wav|rar';
            $config['max_size'] = '';
            $config['encrypt_name'] = TRUE;
            $this->load->library('upload', $config);
            $this->upload->initialize($config);
            if (!$this->upload->do_upload('image')) {
                $error = array('error' => $this->upload->display_errors());
//                var_dump($error);exit;
                $stop_add = true;
                $this->session->set_flashdata('news', t('invalid_photo'));
                redirect($_SERVER ['HTTP_REFERER']);
            } else {
                $data = $this->upload->data('image');
//            var_dump($this->upload->data('image'));
                $_POST['filehid'] = $data['file_name'];
            }
        }
//        var_dump($_FILES);exit;
        $this->photos->add_item($lang_abbr, $item_name, $item_details, $maxcode);
        $this->photos->update_task();
        redirect('admin/dashboard', 'refresh');
    }

    public function showItemsCats() {

        $mktba_id = $this->input->post('mktba_id');

        //$data ['mktba'] = $this->photos->get_mktba ( $mktba_id );

        $cat_code = $this->input->post('item_cat_id');

        $data ['arrs'] = $this->photos->get_items($cat_code);
        foreach ($data['arrs'] as $value) {
            $data['clients'][] = $this->photos->get_client($value['client']);
        }
//        var_dump($data['clients']);
//        exit();

        $this->load->view('photos/item_grid', $data);
    }

    public function deleteItem($code = 0) {

        $mktba_id = $this->uri->segment(5);

        $this->photos->del_item($code);

        $this->session->set_flashdata('message', 'تم الحذف بنجاح');

        redirect('admin/photos/showItems/' . $mktba_id);
    }

    public function get_clients($id = '') {
//        $user = $this->photos->get_user($id);
//        var_dump($user);exit;
//        var_dump($id);exit;
        $data ['clients'] = $this->photos->get_clients($id);
//        var_dump($data['clients']);exit;
        echo json_encode($data);
    }

    public function itemTpl($code = 0, $edit = 0) {

        //$edit = $this->uri->segment ( 6 );

        $data ['langs'] = $this->slang->get_langs();
        $data ['maxcode'] = $this->photos->max_code('item_code', 'photos');
        $data ['larr'] = array();
        $data ['darr'] = array();
        $data['services'] = $this->sites->get_items(2);
        $data['clients'] = $this->photos->get_clients();
        //$code = $this->uri->segment ( 4 );
        $data ['cats'] = $this->photos->get_country();
        if ($edit) {

            $data ['arr'] = $this->photos->get_item($code);

            foreach ($data ['arr'] as $arr) {

                $data ['larr'] [$arr ['item_lang_abbr']] = $arr ['item_name'];

                $data ['darr'] [$arr ['item_lang_abbr']] = $arr ['item_details'];

                $data ['mktba_id'] = $this->uri->segment(5);
            }

            $data ['maxcode'] = $data ['arr'] [0] ['item_code'];
        } else {

            $data ['arr'] = array();

            $data ['mktba_id'] = $this->uri->segment(4);
        }


        //$data ['mktba'] = $this->photos->get_mktba ( $data ['mktba_id'] );

        $this->system_library->load('photos/item_tpl', $data, TRUE);
    }

    public function addItem() {

        $mktba_id = $this->input->post('mktba_id');

        $code = $this->input->post('item_code');

        $item_name = $this->input->post('item_name');

        $item_details = $this->input->post('item_details');

        $lang_abbr = $this->input->post('lang_abbr');

        if ($code != '') {

            $this->photos->del_item($code);
        } else {

            $_POST ['item_code'] = $this->photos->max_code('item_code', 'photos');
        }

        for ($i = 0; $i < count($lang_abbr); $i ++) {

            $this->photos->add_item($lang_abbr [$i], $item_name [$i], $item_details [$i]);
        }

        $_POST ['item_code'] = $this->photos->max_code('item_code', 'photos');

        //var_dump($_POST ['item_code']);
        //exit;

        $this->session->set_flashdata('message', 'تم الحفظ بنجاح');

        redirect('admin/photos/showItems/' . $mktba_id);
    }

    public function download() {

        $id = $this->uri->segment(4);
        $query = $this->photos->download($id);
        $dat = $query->row();
        $name = $dat->item_file;
        $path = "upload" . "/" . $dat->item_file;
//        var_dump($name);
//        exit();
        if (is_file($path)) {
            // required for IE
            if (ini_get('zlib.output_compression')) {
                ini_set('zlib.output_compression', 'Off');
            }
            // get the file mime type using the file extension
            $this->load->helper('file');
            $mime = get_mime_by_extension($path);
            // Build the headers to push out the file properly.
            header('Pragma: public');     // required
            header('Expires: 0');         // no cache
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s', filemtime($path)) . ' GMT');
            header('Cache-Control: private', false);
            header('Content-Type: ' . $mime);  // Add the mime type from Code igniter.
            header('Content-Disposition: attachment; filename="' . basename($name) . '"');  // Add the file name
            header('Content-Transfer-Encoding: binary');
            header('Content-Length: ' . filesize($path)); // provide file size
            header('Connection: close');
            readfile($path); // push it out
            exit();
        }
    }

}

######### end class 

    /* End of file welcome.php */

    /* Location: ./application/controllers/welcome.php */    