$(document).ready(function () {

    var url = window.location.pathname,
            urlRegExp = new RegExp(url.replace(/\/$/, '') + "$"); // create regexp to match current url pathname and remove trailing slash if present as it could collide with the link in navigation in case trailing slash wasn't present there


    //Sidebar Accordion Menu:

    $("#main-nav li ul").hide(); // Hide all sub menus

    // When a top menu item is clicked...
    $("#main-nav li a.nav-top-item").click(
            function () {
                $(this).parent().siblings().find("ul").slideUp("normal"); // Slide up all sub menus except the one clicked
                $(this).next().slideToggle("normal"); // Slide down the clicked sub menu
                return false;
            }
    );

    // When a menu item with no sub menu is clicked...
    $("#main-nav li a.no-submenu").click(
            function () {
                window.location.href = (this.href); // Just open the link instead of a sub menu
                return false;
            }
    );

    // Sidebar Accordion Menu Hover Effect:

    $("#main-nav li .nav-top-item").hover(
            function () {
                $(this).stop().animate({paddingRight: "25px"}, 200);
            },
            function () {
                $(this).stop().animate({paddingRight: "15px"});
            }
    );

    //Minimize Content Box

    $(".content-box-header h3").css({"cursor": "s-resize"}); // Give the h3 in Content Box Header a different cursor
    $(".closed-box .content-box-content").hide(); // Hide the content of the header if it has the class "closed"
    $(".closed-box .content-box-tabs").hide(); // Hide the tabs in the header if it has the class "closed"
    // When the h3 is clicked...
    $(".content-box-header h3").click(
            function () {
                $(this).parent().next().toggle(); // Toggle the Content Box
                $(this).parent().parent().toggleClass("closed-box"); // Toggle the class "closed-box" on the content box
                $(this).parent().find(".content-box-tabs").toggle(); // Toggle the tabs
            }
    );




    $('#main-nav li  a').each(function () {
        // and test its normalized href against the url pathname regexp
        if (urlRegExp.test(this.href.replace(/\/$/, ''))) {
            $(this).addClass('current');



        }
    });

    // Content box tabs:
    /*
     $('.content-box .content-box-content div.tab-content').hide(); // Hide the content divs
     $('ul.content-box-tabs li a.default-tab').addClass('current'); // Add the class "current" to the default tab
     $('.content-box-content div.default-tab').show(); // Show the div with class "default-tab"
     
     $('.content-box ul.content-box-tabs li a').click( // When a tab is clicked...
     function() { 
     $(this).parent().siblings().find("a").removeClass('current'); // Remove "current" class from all tabs
     $(this).addClass('current'); // Add class "current" to clicked tab
     var currentTab = $(this).attr('href'); // Set variable "currentTab" to the value of href of clicked tab
     $(currentTab).siblings().hide(); // Hide all content divs
     $(currentTab).show(); // Show the content div with the id equal to the id of clicked tab
     return false; 
     }
     );
     */
    //Close button:

    $(".close").click(
            function () {
                $(this).parent().fadeTo(400, 0, function () { // Links with the class "close" will close parent
                    $(this).slideUp(400);
                });
                return false;
            }
    );

    // Alternating table rows:

    $('tbody tr:even').addClass("alt-row"); // Add class "alt-row" to even table rows

    // Check all checkboxes when the one in a table head is checked:

    $('.check-all').click(
            function () {
                $(this).parent().parent().parent().parent().find("input[type='checkbox']").attr('checked', $(this).is(':checked'));
            }
    );

    // Initialise Facebox Modal window:

    $('a[rel*=modal]').facebox(); // Applies modal window to any link with attribute rel="modal"

    // Initialise jQuery tinymce:
    // Applies WYSIWYG editor to any textarea with the class "wysiwyg"
    $('textarea.tinymce').tinymce({
        // Location of TinyMCE script
        script_url: base_url + 'assets/admin/js/tiny_mce/tiny_mce.js',
        // General options
        theme: "advanced",
        plugins: "autolink,lists,pagebreak,style,layer,table,save,advhr,advimage,advlink,emotions,iespell,inlinepopups,insertdatetime,preview,media,searchreplace,print,contextmenu,paste,directionality,fullscreen,noneditable,visualchars,nonbreaking,xhtmlxtras,template,advlist",
        extended_valid_elements: "img[!src|border:0|alt|title|width|height|style]a[name|href|target|title|onclick]",
        // Theme options
        theme_advanced_buttons1: "newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,styleselect,formatselect,fontselect,fontsizeselect",
        theme_advanced_buttons2: "cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code,|,insertdate,inserttime,preview,|,forecolor,backcolor",
        theme_advanced_buttons3: "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,emotions,iespell,media,advhr,|,print,|,ltr,rtl,|,fullscreen",
        theme_advanced_buttons4: "insertlayer,moveforward,movebackward,absolute,|,styleprops,|,cite,abbr,acronym,del,ins,attribs,|,visualchars,nonbreaking,template,pagebreak",
        theme_advanced_toolbar_location: "top",
        theme_advanced_toolbar_align: "left",
        theme_advanced_statusbar_location: "bottom",
        theme_advanced_resizing: true,
        plugin_insertdate_dateFormat: "%Y-%m-%d",
        plugin_insertdate_timeFormat: "%H:%M:%S",
        // Skin options
        skin: "o2k7",
        skin_variant: "silver",
        // Example content CSS (should be your site CSS)
        //content_css : "css/content.css",

        // Drop lists for link/image/media/template dialogs
        template_external_list_url: "lists/template_list.js",
        external_link_list_url: "lists/link_list.js",
        external_image_list_url: "lists/image_list.js",
        media_external_list_url: "lists/media_list.js",
        // Replace values for the template plugin
        template_replace_values: {
            username: "Some User",
            staffid: "991234"
        }
    });
    // Initialise jQuery tinymce:
    // Applies WYSIWYG editor to any textarea with the class "wysiwyg"
    $('textarea.tinymcemin').tinymce({
        // Location of TinyMCE script
        script_url: base_url + 'assets/admin/js/tiny_mce/tiny_mce.js',
        // General options
        theme: "advanced"
    });
    //-----uploader ------
    //-- images
    $("#photoflash").uploadify({
        'uploader': base_url + 'assets/admin/js/uploadify.swf',
        'script': photo_upload_url,
        'folder': 'upload',
        'auto': true,
        'multi': true,
        'method': 'POST',
        'fileDataName': 'Filedata',
        'scriptAccess': 'sameDomain',
        'fileExt': '*.jpg;*.jpe;*.jpeg;*.gif;*.png',
        'fileDesc': '*.jpg;*.jpe;*.jpeg;*.gif;*.png',
        /*'buttonImg'     : base_url+'assets/admin/images/browse.png',*/
        'hideButton': false,
        'wmode': 'transparent',
//		<!--'height'		: 22,-->
//		<!--'width'			: 105,-->
        'queueSizeLimit': 40,
        'scriptData': {},
        onSelect: function (event, queueID, fileObj) {},
        onComplete: function (event, queueID, fileObj, response, data) {
            // hide uploade button
            //alert(response)
            //$('#photouploaderdiv').css('display','none');
            $('#photohid').val(response);
            var imgname = response;
            var img = imgname.split('.');
            var newimg = img[0] + "_thumb" + "." + img[1];
            $('#photoul').append("<div><a href=" + base_url + "upload/" + response + " class='imgref'><img src='" + base_url + "assets/admin/images/large-imge.png' alt='صورة الاصلية' title='صورة الاصلية'/> </a>......<img src=" + base_url + "upload/" + newimg + " class='imgref' width='100' height='100'><img src='" + base_url + "assets/admin/images/cross.png' alt='حذف' title='حذف' class='delete_image'/>" + '<input type="hidden" name="photohid[]"  value="' + response + '" />')
            $(".imgref").facebox();
        }

    });
    $('body').delegate('.delete_image', 'click', function () {
        $(this).parent().remove();
    })
    $("#photoflash2").uploadify({
        'uploader': base_url + 'assets/admin/js/uploadify.swf',
        'script': photo_upload_url,
        'folder': 'upload',
        'auto': true,
        'multi': false,
        'method': 'POST',
        'fileDataName': 'Filedata2',
        'scriptAccess': 'sameDomain',
        'fileExt': '*.jpg;*.jpe;*.jpeg;*.gif;*.png',
        'fileDesc': '*.jpg;*.jpe;*.jpeg;*.gif;*.png',
        /*'buttonImg'     : base_url+'assets/admin/images/browse.png',*/
        'hideButton': false,
        'wmode': 'transparent',
//		<!--'height'		: 22,-->
//		<!--'width'			: 105,-->
        'queueSizeLimit': 1,
        'scriptData': {},
        onSelect: function (event, queueID, fileObj) {},
        onComplete: function (event, queueID, fileObj, response, data) {
            // hide uploade button
            //alert(response)
            $('#photouploaderdiv2').css('display', 'none');
            $('#photohid2').val(response);
            var imgname = response;
            var img = imgname.split('.');
            var newimg = img[0] + "_thumb" + "." + img[1];
            $('#photoul2').html("<a href=" + base_url + "upload/" + response + " class='imgref'><img src='" + base_url + "assets/admin/images/large-imge.png' alt='صورة الاصلية' title='صورة الاصلية'/> </a>......<a href=" + base_url + "upload/" + newimg + " class='imgref'><img src='" + base_url + "assets/admin/images/small-imge.png' alt='صورة مصغرة' title='صورة مصغرة'/> </a>")
            $(".imgref").facebox();
        }

    });
    $("#fileflash").uploadify({
        'uploader': base_url + 'assets/admin/js/uploadify.swf',
        'script': file_upload_url,
        'folder': 'upload',
        'auto': true,
        'multi': false,
        'method': 'POST',
        'fileDataName': 'Filedata2',
        'scriptAccess': 'sameDomain',
        'fileExt': ';*.mp3;*.pdf;*.doc;*.ppt;*.zip;*.docx;*.xlsx;*.xls;*.rmvb',
        'fileDesc': ';*.mp3;*.pdf;*.doc;*.ppt;*.zip;*.docx;*.xlsx;*.xls;*.rmvb',
        /* 	'buttonImg'     : base_url+'assets/admin/images/browse.png',*/
        'hideButton': false,
        'wmode': 'transparent',
//		<!--'height'		: 22,-->
//		<!--'width'			: 105,-->
        'queueSizeLimit': 1,
        'scriptData': {},
        onSelect: function (event, queueID, fileObj) {},
        onComplete: function (event, queueID, fileObj, response, data) {
            // hide uploade button
            //alert(response)
            //$('#fileploaderdiv').css('display','none');
            $('#filehid').val(response);
            $('#fileul').html(response);

        }

    });

    $("#videoflash").uploadify({
        'uploader': base_url + 'assets/admin/js/uploadify.swf',
        'script': file_upload_url,
        'folder': 'upload',
        'auto': true,
        'multi': false,
        'method': 'POST',
        'fileDataName': 'Filedata2',
        'scriptAccess': 'sameDomain',
        'fileExt': ';*.mp4;*.flv;*.rmvb;*.wmv;*.avi;*.wmv',
        'fileDesc': ';*.mp4;*.flv;*.rmvb;*.wmv;*.avi;*.wmv',
        /* 	'buttonImg'     : base_url+'assets/admin/images/browse.png',*/
        'hideButton': false,
        'wmode': 'transparent',
//		<!--'height'		: 22,-->
//		<!--'width'			: 105,-->
        'queueSizeLimit': 1,
        'scriptData': {},
        onSelect: function (event, queueID, fileObj) {},
        onComplete: function (event, queueID, fileObj, response, data) {
            // hide uploade button
            //alert(response)
            $('#fileploaderdiv').css('display', 'none');
            $('#filehid').val(response);
            $('#fileul').html(response);

        }

    });

    $("#datepicker").datepicker({dateFormat: 'yy-mm-dd'});
});

function show_confirm(title)
{
    var a = confirm(title);
    if (a == true)
    {
        return true;
    } else
    {
        return false;
    }

}

/*
 $(function(){
 
 var url = window.location.pathname, 
 urlRegExp = new RegExp(url.replace(/\/$/,'') + "$"); // create regexp to match current url pathname and remove trailing slash if present as it could collide with the link in navigation in case trailing slash wasn't present there
 // now grab every link from the navigation
 $('.menu a').each(function(){
 // and test its normalized href against the url pathname regexp
 if(urlRegExp.test(this.href.replace(/\/$/,''))){
 $(this).addClass('current');
 }
 });
 
 });
 
 */