<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class admin extends MX_Controller {

    function __construct() {
        $this->lang->load('admin');
        $this->load->model('Dashboard_model', 'user');
        $this->load->model('News_model', 'news');
        $this->load->model('Setting_model', 'setting');

        $this->load->library('phpass_library');
    }

    public function index() {

        $this->load->view('login');
    }

    function login() {

        if (!$this->access_library->is_logged_in()) {
            if ($this->input->post('username') != "" && $this->input->post('password') != "") {
                $this->user->verify_user($this->input->post('username'), $this->input->post('password'));
                //var_dump($_POST);exit;
                if ($this->session->userdata('level') == 2) {
                    $this->user->update_last_login();

                    redirect('admin/dashboard', 'refresh');
                } else {
                    $this->session->set_flashdata('message', 'غير مصرح لك بالدخول');
                    redirect('admin', 'refresh');
                }
            } else {
                $this->session->set_flashdata('message', 'من فضلك ادخل اسم المستخدم وكلمة المرور');
                redirect('admin', 'refresh');
            }
        } else {
            if ($this->access_library->is_admin()) {
                redirect('admin/dashboard', 'refresh');
            } else {
                $this->session->set_flashdata('message', 'غير مصرح لك بالدخول');
                redirect('admin', 'refresh');
            }
        }
    }

    public function logout() {
        if ($this->access_library->is_logged_in()) {
            $this->user->logout();

            redirect('admin', 'refresh');
        } else {
            redirect('admin', 'refresh');
        }
    }

    function changePass() {
        $newpass = random_string('alnum', 16);

        $emaila = $this->input->post('admin_email');

        $info = $this->user->get_user_by_email($emaila);
        if (count($info) > 0) {
            $this->db->set('password', do_hash($newpass, 'md5'));
            $this->db->where('id', '-1');
            $this->db->update('users');


            $this->email->to($info['email']);
            $this->email->from($info['email']);

            $this->email->subject('كلمة المرور الجديدة ل ' . $this->system_library->settings['site_title']);
            $this->email->message('كلمة المرور الجديدة هي  <br>' . $newpass);
            $this->email->send();
        } else {
            $this->session->set_flashdata('messagechange', 'البريد الالكتروني الذي ادخلته غير صحيح');
            redirect('admin', 'refresh');
        }
    }

    function dashboard() {
        $data['user'] = "";
        $data['arrs'] = "";
        if ($this->access_library->is_admin()) {
            if ($this->session->userdata('user_id') == - 1 || $this->session->userdata('type') == 3) {
                $data['setting'] = $this->setting->get_settings();
                $data['clients'] = $this->user->count_clients(0);
                $data['clients_ar'] = $this->user->count_clients(1);
                $data['task'] = $this->user->count_tasks();
                $data['users'] = $this->user->count_users();
                $this->system_library->load("dashboard", $data, TRUE);
            } elseif ($this->session->userdata('type') != 3) {
                $data['title'] = "Task Tap";
                $id = $this->session->userdata('user_id');
                if ($this->session->userdata('type') == 1) {
                    $tsk_id = $this->news->get_task_user($id);
                    if ($tsk_id) {
                        foreach ($tsk_id as $value) {
                            $data['arrs'][] = $this->news->get_itemm($value['item_code'], 0);
                        }
                    }
                    if ($data['arrs']) {
                        for ($i = 0; $i < count($data['arrs']); $i++) {
                            $data['arrs']['tasks'][$i] = $this->news->get_task($data['arrs'][$i]['item_code']);
                        }
                    }
                    $this->system_library->load("dashboard", $data, TRUE);
                } elseif ($this->session->userdata('type') == 2) {
//                    $jobs = $this->news->getJobTeamLeader($id);
//                    foreach ($jobs as $value) {
//                        $cats [] = $value['jobParent'];
//                    }
//                    $data['arrs'] = $this->news->get_itemmTramleader($cats);
////                    var_dump($data['arrs']); exit;
//                    for ($i = 0; $i < count($data['arrs']); $i++) {
//                        $data['arrs']['tasks'][$i] = $this->news->get_task($data['arrs'][$i]['item_code']);
//                    }
                   redirect('admin/news/showItems', 'refresh');
                }


                // var_dump($this->session->userdata('type'));exit;
            }
        } else {
            redirect('admin', 'refresh');
        }
    }

    public function task() {
        $data['title'] = "Task Archive";
        $id = $this->session->userdata('user_id');
        if ($this->session->userdata('type') == 1) {
            $tsk_id = $this->news->get_task_user($id);
            foreach ($tsk_id as $value) {
                $data['arrs'][] = $this->news->get_itemm($value['item_code'], 2);
            }

            for ($i = 0; $i < count($data['arrs']); $i++) {
                $data['arrs']['tasks'][$i] = $this->news->get_task($data['arrs'][$i]['item_code']);
            }
        } elseif ($this->session->userdata('type') == 2) {
            $jobs = $this->news->getJobTeamLeader($id);
            foreach ($jobs as $value) {
                $_POST['item_cat_id'] = $value['job_id'];
//                var_dump($_POST)
                $data['arrs'] [] = $this->news->get_itemm('', 2);
            }
//                    var_dump($data['arrs']);exit;
            for ($i = 0; $i < count($data['arrs']); $i++) {
                $data['arrs']['tasks'][$i] = $this->news->get_task($data['arrs'][$i]['item_code']);
            }
        }

        $this->system_library->load("dashboard", $data, TRUE);
    }

    function update_notes() {

        $this->setting->update_note();
        $this->session->set_flashdata('message', 'تم الحفظ بنجاح');
        redirect('admin/dashboard', 'refresh');
    }

    function filemanager() {

        $this->system_library->load("filemanager", "", TRUE);
    }

    function uploadphoto() {


        //$_FILES['filedata']['name'];
        $uploaddir = 'upload/';
        $config['upload_path'] = $uploaddir;
        $config['allowed_types'] = 'jpg|jpe|jpeg|gif|png';
        $config['max_size'] = '0';
        $config['encrypt_name'] = TRUE;


        $this->load->library('upload', $config);
//$this->load->library('image_lib');
        $this->upload->initialize($config);


        if (!$this->upload->do_upload('Filedata')) {
            echo $this->upload->display_errors('<p>', '</p>');
            print_r($_FILES);
        } else {
            $data = $this->upload->data();
            $this->thumbimages($data['file_name']);
            echo $data['file_name'];
        }
    }

    function uploadphoto2() {


        //$_FILES['filedata']['name'];
        $uploaddir = 'upload/';
        $config['upload_path'] = $uploaddir;
        $config['allowed_types'] = 'jpg|jpe|jpeg|gif|png';
        $config['max_size'] = '0';
        $config['encrypt_name'] = TRUE;


        $this->load->library('upload', $config);
//$this->load->library('image_lib');
        $this->upload->initialize($config);


        if (!$this->upload->do_upload('Filedata2')) {
            echo $this->upload->display_errors('<p>', '</p>');
            print_r($_FILES);
        } else {
            $data = $this->upload->data();
            $this->thumbimages($data['file_name']);
            echo $data['file_name'];
        }
    }

    function thumbimages($mgsrc = '') {
//$this->load->library('image_lib');


        $config['image_library'] = 'gd2';
        $config['source_image'] = 'upload/' . $mgsrc;
        $config['create_thumb'] = TRUE;
        $config['maintain_ratio'] = FALSE;
        $config['width'] = $this->system_library->settings['thumb_width'];
        $config['height'] = $this->system_library->settings['thumb_height'];


        $this->image_lib->initialize($config);

        if (!$this->image_lib->resize())
            return $this->image_lib->display_errors();
        else
            return 1;
    }

    function uploadfile() { //upload image 
//var_dump($_FILES);  
        //$_FILES['filedata']['name'];
        $uploaddir = 'upload/';
        $config['upload_path'] = $uploaddir;
        $config['allowed_types'] = 'pdf|doc|ppt|zip|docx|xlsx|xls|avi|mp4|mp3|rmvb|avi|flv|wmv|wav|rar';
        $config['max_size'] = '0';
        $config['encrypt_name'] = TRUE;
        $this->load->library('upload', $config);
        //$this->load->library('image_lib');
        $this->upload->initialize($config);

        if (!$this->upload->do_upload('Filedata2')) {
            //var_dump($this->upload->display_errors());
            echo $this->upload->display_errors('<p>', '</p>');
            //print_r($_FILES); 
        } else {
            $data = $this->upload->data();
            //$this->thumbimages($data['file_name']);
            echo $data['file_name'];
        }
    }

    public
            function update_password() {
        $id = $this->session->userdata('user_id');
        $this->user->update_password($id);
        $this->session->set_flashdata('message', 'تم الحفظ بنجاح');
        redirect('admin/setting/settingTpl');
    }

}

######### end class 

    /* End of file welcome.php */
    /* Location: ./application/controllers/welcome.php */    