<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Applications extends MX_Controller {

    function __construct() {
        $this->lang->load('admin');
        $this->load->model('Applications_model', 'applications');
        $this->load->model('Langs_model', 'slang');
        // Check if the logged user is an administrator
        $this->access_library->check_access();
    }

############################### estsharas ################# 	

    public function showEstsharas($type = 1) {
        $data['type'] = $type;
        $data['panelTitle'] = t('circle_state');
        $data['arrs'] = $this->applications->get_estshara(0, $type);
        $this->system_library->load('applications/estshara_list', $data, TRUE);
    }

    public function updateEstsharas($id = 0, $type = 1) {
        $this->applications->update_Estshara($id);
        $this->session->set_flashdata('message', 'تم التعديل بنجاح');
        redirect('admin/applications/showEstsharas/' . $type);
    }

    public function deleteEstsharas($id = 0, $type) {
        $this->applications->del_Estshara($id);
        $this->session->set_flashdata('message', 'تم الحذف بنجاح');
        redirect('admin/applications/showEstsharas/' . $type);
    }

    public function estsharasTpl($id = 0, $type = 1) {

        $data['arr'] = $this->applications->get_estshara($id);
        $data['panelTitle'] = 'الااستشارات';
        //$data['panelTitle']='اراء المستخدمين';
        $data['panelTitle'] = $data['arr'][0]['subject'];
        $data['labels'] = array('code' => 'كود الاشتراك', 'item_name' => 'المؤتمر', 'name' => 'الاسم', 'national_number' => 'رقم الوية', 'phone' => 'الهاتف', 'category' => 'النوع', 'email' => 'البريد الالكترونى', 'subject' => 'العنوان', 'old_date' => 'التاريخ القديم', 'new_date' => 'التاريخ الجديد', 'message' => 'المحتوى');
        $data['action'] = 'admin/applications/deleteEstsharas/';
        $this->system_library->load('applications/estshara_tpl', $data, TRUE);
    }

################ APPS #######

    public function show($app = 0) {
        $app = $this->input->post('app');
        switch ($type) {
            case '1':
                $data['result'] = $this->applications->get_badal(1);
                break;
            case '2':
                $data['result'] = $this->applications->get_badal(2);
                break;
            case '3':
                $data['result'] = $this->applications->get_waseqa();
                break;
            case '4':
                $data['result'] = $this->applications->get_student();
                break;
            case '5':
                $data['result'] = $this->applications->get_question();
                break;
        }
        $this->system_library->load('users/list_apps', $data, TRUE);
    }

}

######### end class 
?>