<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Audios extends MX_Controller {

    function __construct() {
        $this->lang->load('admin');
        $this->load->model('Audios_model', 'audios');
        $this->load->model('Langs_model', 'slang');
        // Check if the logged user is an administrator
        $this->access_library->check_access();
    }

############################### cats ################# 	

    public function showCats() {
        $mktba_id = $this->uri->segment(4);
        $data['mktba'] = $this->audios->get_mktba($mktba_id);

        $data['arrs'] = $this->audios->get_cats($mktba_id);
        $this->system_library->load('audios/cats_list', $data, TRUE);
    }

    public function deleteCats() {
        $mktba_id = $this->uri->segment(5);
        $this->audios->del_cats();
        $this->session->set_flashdata('message', 'تم الحذف بنجاح');
        redirect('admin/audios/showCats/' . $mktba_id);
    }

    public function catsTpl() {
        $edit = $this->uri->segment(6);
        $data['langs'] = $this->slang->get_langs();
        $data['maxcode'] = $this->audios->max_code('cats_code', 'cat_audios');



        $code = $this->uri->segment(4);
        if ($edit) {
            $data['arr'] = $this->audios->get_new($code);
            foreach ($data['arr'] as $arr) {
                $data['larr'][$arr['lang_abbr']] = $arr['title'];
            }

            $data['maxcode'] = $data['arr'][0]['cats_code'];
            $data['mktba_id'] = $this->uri->segment(5);
        } else {
            $data['arr'] = array();
            $data['mktba_id'] = $this->uri->segment(4);
        }
        $data['mktba'] = $this->audios->get_mktba($data['mktba_id']);
        $this->system_library->load('audios/cats_tpl', $data, TRUE);
    }

    public function addCats() {
        $mktba_id = $this->input->post('mktba_id');
        $data['mktba'] = $this->audios->get_mktba($mktba_id);

        $code = $this->input->post('code');
        $title = $this->input->post('title');
        $lang_abbr = $this->input->post('lang_abbr');

        if ($code != '') {
            $this->audios->del_cats($code);
        }

        for ($i = 0; $i < count($lang_abbr); $i++) {
            $this->audios->add_cats($lang_abbr[$i], $title[$i], $mktba_id);
        }

        $this->session->set_flashdata('message', 'تم الحفظ بنجاح');
        redirect('admin/audios/showCats/' . $mktba_id);
    }

############################### items ################# 	

    public function showItems() {
        $mktba_id = $this->uri->segment(4);
        $data['mktba'] = $this->audios->get_mktba($mktba_id);
        $data['cats'] = $this->audios->get_cats($mktba_id);

        $this->system_library->load('audios/item_list', $data, TRUE);
    }

    public function showItemsCats() {
        $mktba_id = $this->input->post('mktba_id');
        $data['mktba'] = $this->audios->get_mktba($mktba_id);
        $cat_code = $this->input->post('item_cat_id');
        $data['arrs'] = $this->audios->get_items($cat_code);

        $this->load->view('audios/item_grid', $data);
    }

    public function deleteItem() {
        $mktba_id = $this->uri->segment(5);
        $this->audios->del_item();
        $this->session->set_flashdata('message', 'تم الحذف بنجاح');
        redirect('admin/audios/showItems/' . $mktba_id);
    }

    public function itemTpl() {


        $edit = $this->uri->segment(6);
        $data['langs'] = $this->slang->get_langs();
        $data['maxcode'] = $this->audios->max_code('item_code', 'audios');


        $data['larr'] = array();
        $data['darr'] = array();
        $code = $this->uri->segment(4);
        if ($edit) {
            $data['arr'] = $this->audios->get_item($code);
            foreach ($data['arr'] as $arr) {
                $data['larr'][$arr['item_lang_abbr']] = $arr['item_name'];
                $data['darr'][$arr['item_lang_abbr']] = $arr['item_name2'];
                $data['carr'][$arr['item_lang_abbr']] = $arr['item_city'];
                $data['charr'][$arr['item_lang_abbr']] = $arr['item_channel'];
                $data['comparr'][$arr['item_lang_abbr']] = $arr['item_comp'];

                $data['mktba_id'] = $this->uri->segment(5);
            }

            $data['maxcode'] = $data['arr'][0]['item_code'];
        } else {
            $data['arr'] = array();
            $data['mktba_id'] = $this->uri->segment(4);
        }

        $data['cats'] = $this->audios->get_cats($data['mktba_id']);
        $data['mktba'] = $this->audios->get_mktba($data['mktba_id']);
        $this->system_library->load('audios/item_tpl', $data, TRUE);
    }

    public function addItem() {

        $mktba_id = $this->input->post('mktba_id');


        $code = $this->input->post('item_code');
        $item_name = $this->input->post('item_name');
        $item_name2 = $this->input->post('item_name2');
        $lang_abbr = $this->input->post('lang_abbr');

        $item_city = $this->input->post('item_city');
        $item_channel = $this->input->post('item_channel');
        $item_comp = $this->input->post('item_comp');


        if ($code != '') {
            $this->audios->del_item($code);
        }

        for ($i = 0; $i < count($lang_abbr); $i++) {
            $this->audios->add_item($lang_abbr[$i], $item_name[$i], $item_name2[$i], $item_city[$i], $item_channel[$i], $item_comp[$i]);
        }

        $this->session->set_flashdata('message', 'تم الحفظ بنجاح');
        redirect('admin/audios/showItems/' . $mktba_id);
    }

}

######### end class 

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */