<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Courses extends MX_Controller {

function __construct() {
	$this->lang->load('admin');
  	$this->load->model('Courses_model', 'courses');
  	$this->load->model('Langs_model', 'slang');
	// Check if the logged user is an administrator
  	$this->access_library->check_access();
 }
############################### courses ################# 	
	public function showCourses()
	{
		$data['panelTitle']=t('course_course');
		//extract($_POST);
		if(count($_POST)){
			$data['arrs'] = $this->courses->get_course();
			$data['ajax'] = 1;
			$this->load->view('courses/courses_list', $data);
		}else{
			$data['arrs'] = $this->courses->get_course();
			$this->system_library->load('courses/courses_list', $data, TRUE);
		}
	}	
	
	public function deleteCourses($id=0)
	{
	  $this->courses->del_Course($id);
	  $this->session->set_flashdata('message', 'تم الحذف بنجاح');
	  redirect('admin/courses/showCourses/');
	}	
	
	public function coursesTpl($id=0)
	{
		if($id){
			$data['arr'] = $this->courses->get_course($id);
		}else{
			$data['arr']=array();
		}
	    $this->system_library->load('courses/courses_tpl', $data, TRUE);
	}
	
	public function opCourses($id=0)
	{
		//$data['panelTitle']=t('course_course');
		//var_dump($_POST);
		$start_date=strtotime($this->input->post('start_date'));
		$end_date=strtotime($this->input->post('end_date'));
		if($end_date<$start_date){
			$this->session->set_flashdata('message', 'التواريخ غير صحيحه يجب ان يكون تاريخ النهايه اكبر من تاريخ البدايه');
		    redirect('admin/courses/coursesTpl/');
		}
		$this->courses->op_courses($id);
		$this->session->set_flashdata('message', 'تم الحفظ بنجاح');
	    redirect('admin/courses/showCourses/');
	}
}######### end class 
?>