<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class News extends MX_Controller {

    function __construct() {
        $this->lang->load('admin');
        $this->load->model('News_model', 'news');
        $this->load->model('Langs_model', 'slang');
        $this->load->model('Users_model', 'user');
        $this->load->model('Clients_model', 'clients');
        // Check if the logged user is an administrator
        $this->access_library->check_access();
    }

############################### cats ################# 	

    public function showCats() {
        $mktba_id = $this->uri->segment(4);
        $data['arrs'] = $this->news->get_cats();
        $this->system_library->load('news/cats_list', $data, TRUE);
    }

    public function deleteCats() {
        $this->news->del_cats();
        $this->session->set_flashdata('message', 'تم الحذف بنجاح');
        redirect('admin/news/showCats/');
    }

    public function catsTpl() {
        $edit = $this->uri->segment(5);
        $data['langs'] = $this->slang->get_langs();
        $data['maxcode'] = $this->news->max_code('cats_code', 'cat_news');
        $data ['cats'] = $this->news->get_cats(0);
        $code = $this->uri->segment(4);
        if ($edit) {
            $data['arr'] = $this->news->get_new($code);
            foreach ($data['arr'] as $arr) {
                $data['larr'][$arr['lang_abbr']] = $arr['title'];
                $data['darr'][$arr['lang_abbr']] = $arr['details'];
            }
            $data['maxcode'] = $data['arr'][0]['cats_code'];
            $data['mktba_id'] = $this->uri->segment(5);
        } else {
            $data['arr'] = array();
        }
        $this->system_library->load('news/cats_tpl', $data, TRUE);
    }

    public function addCats() {
        $code = $this->input->post('code');
        $title = $this->input->post('title');
        $details = $this->input->post('details');
        $lang_abbr = $this->input->post('lang_abbr');
        if ($code != '') {
            $this->news->del_cats($code);
        }
        for ($i = 0; $i < count($lang_abbr); $i++) {
            if (empty($title[$i])) {
                $this->session->set_flashdata('message', 'Some Boxs is Empty');
                redirect($_SERVER['HTTP_REFERER']);
            } else {
                if (!strip_tags(filter_var($title[$i], FILTER_SANITIZE_STRING))) {
                    $this->session->set_flashdata('message', 'Invalid Data Type');
                    redirect($_SERVER['HTTP_REFERER']);
                } else {
                    $this->news->add_cats($lang_abbr[$i], $title[$i], $details[$i]);
                }
            }
        }
        $this->session->set_flashdata('message', 'تم الحفظ بنجاح');
        redirect('admin/news/showCats/');
    }

############################### items ################# 	

    public function showItems() {
        $cats = "";
        if ($this->session->userdata('type') == 2) {
            $id = $this->session->userdata('user_id');
            $jobs = $this->news->getJobTeamLeader($id);
            foreach ($jobs as $value) {
                $cats [] = $value['jobParent'];
            }
        }
        $data['cats'] = $this->news->get_cats(0, $cats);
        $data['projects'] = $this->clients->getProjects();
        //var_dump($data['cats']);

        $this->system_library->load('news/item_list', $data, TRUE);
    }

    public function project() {
        $this->load->view('news/project', $data);
    }

    public function showItemsCats() {
        $id = $this->input->post('item_cat_id');
        $data['arrs'] = $this->news->get_items($id);
        if ($data['arrs']) {
            for ($i = 0; $i < count($data['arrs']); $i++) {
                $data['arrs']['tasks'][$i] = $this->news->get_task($data['arrs'][$i]['item_code']);
            }
        }

        // echo '<pre>';var_dump($data['arrs']['tasks']);exit;
        $this->load->view('news/item_grid', $data);
    }

    public function task() {
        $item_code = $this->input->post('item_code');
        $data['arrs'] = $this->news->get_itemm($item_code);
        $data['task'] = $this->news->get_task($item_code);
        foreach ($data['task'] as $value) {
            $data['user'][] = $this->news->get_user($value['user_id']);
        }

//        var_dump($data['task']);exit;
        $this->load->view('news/task', $data);
    }

    public function deleteItem() {
        $taskcode = $this->uri->segment(4);
        $this->news->del_item();
        $this->news->delete_task($taskcode);
//        $this->news->delete_photo();
        $this->session->set_flashdata('message', 'تم الحذف بنجاح');
        redirect('admin/news/showItems/0');
    }

    public function projects() {
        $_POST['client'] = $this->input->post('item_user_id');
        $data['project_id'] = $this->input->post('project_id');
        if ($_POST['client']) {
            $data['projects'] = $this->clients->getProjects();
        }

        $this->load->view('news/projects', $data);
    }

    public function itemTpl() {
        $edit = $this->uri->segment(5);
        $data['langs'] = $this->slang->get_langs();
        $data['maxcode'] = $this->news->max_code('item_code', 'news');
        $data['user'] = $this->news->get_client();

        $data['larr'] = array();
        $data['darr'] = array();
        $code = $this->uri->segment(4);
        if ($edit) {
            $data['arr'] = $this->news->get_item($code);
            $data['edit'] = "edit";

            foreach ($data['arr'] as $arr) {
                $data['larr'][$arr['item_lang_abbr']] = $arr['item_name'];
                $data['darr'][$arr['item_lang_abbr']] = $arr['item_details'];
            }
            $data['maxcode'] = $data['arr'][0]['item_code'];
        } else {
            $data['arr'] = array();
        }

        $data['cats'] = $this->news->get_cats();
        $this->system_library->load('news/item_tpl', $data, TRUE);
    }

    public function edit() {
        $code = $this->input->post('item_code');

//        var_dump($code);exit;
        $data['langs'] = $this->slang->get_langs();

        $data['larr'] = array();
        $data['darr'] = array();
        $data['arr'] = $this->news->get_item($code);
        $data['task'] = $this->news->get_task($code);
        foreach ($data['arr'] as $arr) {
            $data['larr'][$arr['item_lang_abbr']] = $arr['item_name'];
            $data['darr'][$arr['item_lang_abbr']] = $arr['item_details'];
        }
        $data['cats'] = $this->news->get_cats();
        $this->load->view('header');
        $this->load->view('edit', $data);
        $this->load->view('footer');
    }

    public function addItem() {
        $code = $this->input->post('item_code');
        $item_name = $this->input->post('item_name');
        $item_details = $this->input->post('item_details');
        $lang_abbr = $this->input->post('lang_abbr');
        if ($code != '') {
            $this->news->del_item($code);
        }

        for ($i = 0; $i < count($lang_abbr); $i++) {
            $this->news->add_item($lang_abbr[$i], $item_name[$i], $item_details[$i]);
        }
        $this->session->set_flashdata('message', 'تم الحفظ بنجاح');
        $user = $this->news->getTeamLeaderId($this->input->post('item_cat_id'));
//        var_dump($user);exit;
        $message = "Pleas Check Your Account in The System You Have New Project : " . $item_name[0]['item_name'] . " It Will Begin In : '" . $this->input->post('item_created_date') . "'  Expected End Date : '" . $this->input->post('item_end_date') . "'";
        $this->sendEmail($user['id'], $message);
        if ($this->session->userdata('user_id') == -1) {
            redirect('admin/news/showItems/0');
        } else {
            redirect('admin/dashboard');
        }
    }

    public function employeGrid() {
        $item_code = $this->uri->segment(4);
        $data['project'] = $this->news->get_itemm($item_code);
        $data['users'] = $this->news->get_task($item_code);
        $this->system_library->load('news/employeGrid', $data, TRUE);
    }

    public function employeeTpl() {
        $data['item_code'] = $this->uri->segment(4);
        $item_cat_id = $this->uri->segment(5);
        $user_id = $this->uri->segment(6);
        $data['project'] = $this->news->get_itemm($data['item_code']);
        $data['users'] = $this->news->getJobs($item_cat_id);
        if ($user_id) {
            $data['arr'] = $this->news->getTask($user_id, $data['item_code']);
//            var_dump($data['arr']);exit;
        }
        $this->system_library->load('news/emp', $data, TRUE);
    }

    public function addUserTask() {
        $edit = $this->uri->segment(4);
        $user_id = $this->input->post('user_id');
        $details = $this->input->post('details');
        $item_code = $this->input->post('item_code');
        $task = $this->news->get_itemm($item_code);
//        var_dump($_POST);exit;
        if ($edit) {
            $this->news->update_task($item_code, $user_id, $details);
        } else {
            $this->news->add_task($user_id, $details);
        }
        $message = "Pleas Check Your Account in The System You Have New Project : " . $task['item_name'] . " It Will Begin In : '" . $task['item_created_date'] . "'  Expected End Date : '" . $task['item_end_date'] . "'";
        $this->sendEmail($user_id, $message);
        $this->session->set_flashdata('message', 'تم الحفظ بنجاح');
        redirect('admin/news/employeGrid/' . $item_code);
    }

    public function deleteTask() {
        $_POST['user_id'] = $this->uri->segment(4);
        $item_code = $this->uri->segment(5);
        $this->news->delete_task($item_code);
        $this->session->set_flashdata('message', 'تم الحذف بنجاح');
        redirect('admin/news/employeGrid/' . $item_code);
    }

    public function sendEmail($user_id, $message) {
        $user = $this->user->get_user($user_id);
        $subject = "Notification Alyom Host";
        $email = $user['email'];
        $senderemail = $this->system_library->settings['admin_email'];
        $this->load->library('email');
        $this->email->from($senderemail, $this->system_library->settings['site_title']);
        $this->email->to($email);
        $this->email->subject($subject);
        $this->email->message($message);
        $this->email->send();
    }

    public function update_task() {
        date_default_timezone_set("Africa/Cairo");
        $id = $this->session->userdata('user_id');
        $item_code = $this->input->post('item_code');
        $persomalNotes = $this->input->post('persomalNotes');
        $notes = $this->input->post('notes');
        $active = $this->input->post('active');

        $_POST['type'] = 3;
        $user = $this->user->get_user($id);
        $manger = $this->user->get_user(-1);
        $item = $this->news->get_itemm($item_code);
        if ($active == 1) {
            $message = $user['display_name'] . " End the Task ('" . $item['item_name'] . "') End Time : '" . date('Y-m-d H:i:s') . "'";

            $_POST['type'] = 2;
            $teamLeader = $this->news->getTeamLeaderId($item['item_cat_id']);
            if ($teamLeader) {
                $this->sendEmail($teamLeader['id'], $message);
            }
            $this->sendEmail($manger['id'], $message);
        }


        if ($notes) {
            if (!strip_tags(filter_var($notes, FILTER_SANITIZE_STRING))) {
                $this->session->set_flashdata('warning', 'Invalid Data');
                redirect('admin/dashboard');
            }
        }
        if ($persomalNotes) {
            if (!strip_tags(filter_var($persomalNotes, FILTER_SANITIZE_STRING))) {
                $this->session->set_flashdata('warning', 'Invalid Data');
                redirect('admin/dashboard');
            }
        }
        $this->news->update_task($item_code, $id);
        $this->session->set_flashdata('message', 'تم الحفظ بنجاح');
        redirect('admin/dashboard');
    }

}

######### end class 

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */