<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Sites extends MX_Controller {

    function __construct() {
        $this->lang->load('admin');
        $this->load->model('Sites_model', 'sites');
        $this->load->model('Langs_model', 'slang');
        // Check if the logged user is an administrator
        $this->access_library->check_access();
    }

    ############################### cats ################# 	

    public function showCats() {
        $data['arrs'] = $this->sites->get_cats();
        $this->system_library->load('sites/cats_list', $data, TRUE);
    }

    public function deleteCats() {
        $this->sites->del_cats();
        $this->session->set_flashdata('message', 'تم الحذف بنجاح');
        redirect('admin/sites/showCats');
    }

    public function catsTpl() {
        $data['langs'] = $this->slang->get_langs();
        $data['maxcode'] = $this->sites->max_code('cats_code', 'cat_sites');
        $code = $this->uri->segment(4);
        if ($code) {
            $data['arr'] = $this->sites->get_cat($code);
            foreach ($data['arr'] as $arr) {
                $data['larr'][$arr['lang_abbr']] = $arr['title'];
            }
            $data['maxcode'] = $data['arr'][0]['cats_code'];
        } else {
            $data['arr'] = array();
        }
        $this->system_library->load('sites/cats_tpl', $data, TRUE);
    }

    public function addCats() {
        $code = $this->input->post('code');
        $title = $this->input->post('title');
        $lang_abbr = $this->input->post('lang_abbr');
        if ($code != '') {
            $this->sites->del_cats($code);
        }
        for ($i = 0; $i < count($lang_abbr); $i++) {
            $this->sites->add_cats($lang_abbr[$i], $title[$i]);
        }
        $this->session->set_flashdata('message', 'تم الحفظ بنجاح');
        redirect('admin/sites/showCats');
    }

    ############################### items ################# 	

    public function showItems() {
        $data['cats'] = $this->sites->get_cats();
        $this->system_library->load('sites/item_list', $data, TRUE);
    }

    public function showItemsCats() {
        $cat_code = $this->input->post('item_cat_id');
        $data['arrs'] = $this->sites->get_items($cat_code);
        $this->load->view('sites/item_grid', $data);
    }

    public function deleteItem() {
        $this->sites->del_item();
        $this->session->set_flashdata('message', 'تم الحذف بنجاح');
        redirect('admin/sites/showItems');
    }

    public function itemTpl() {
        $data['langs'] = $this->slang->get_langs();
        $data['maxcode'] = $this->sites->max_code('item_code', 'sites');
        $data['cats'] = $this->sites->get_cats();
        $this->load->model('News_model', 'news');
        $data['news_cats'] = $this->news->get_cats(10, 2);
        $data['larr'] = array();
        $data['darr'] = array();
        $code = $this->uri->segment(4);
        if ($code) {
            $data['arr'] = $this->sites->get_item($code);
            foreach ($data['arr'] as $arr) {
                $data['larr'][$arr['item_lang_abbr']] = $arr['item_name'];
                $data['darr'][$arr['item_lang_abbr']] = $arr['item_details'];
            }
            $data['maxcode'] = $data['arr'][0]['item_code'];
        } else {
            $data['arr'] = array();
        }
        $this->system_library->load('sites/item_tpl', $data, TRUE);
    }

    public function addItem() {
        $code = $this->input->post('item_code');
        $item_name = $this->input->post('item_name');
        $item_details = $this->input->post('item_details');
        $lang_abbr = $this->input->post('lang_abbr');
        if ($code != '') {
            $this->sites->del_item($code);
        }
        for ($i = 0; $i < count($lang_abbr); $i++) {
            $this->sites->add_item($lang_abbr[$i], $item_name[$i], $item_details[$i]);
        }
        $this->session->set_flashdata('message', 'تم الحفظ بنجاح');
        redirect('admin/sites/showItems');
    }

}

######### end class 

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */