<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Users extends MX_Controller {

    function __construct() {
        $this->lang->load('admin');
        $this->load->model('Users_model', 'users');
        $this->load->model('News_model', 'news');
        // Check if the logged user is an administrator
        $this->access_library->check_access();
    }

    function listUser($order = 0) {
        //if($order=='asc'||$order=='desc'){
            $data['order'] = $order;
        //}
        $this->system_library->load('users/list', $data, TRUE);
    }

    public function showall($order = '', $term = '') {

        //-- paging ----
        if (!$term)
            $term = check($_REQUEST['term']);
        $config['base_url'] = site_url('admin/users/showall');
        $data['order'] = $order;
        $config['div'] = 'tab1';
        $config['uriseg'] = check($_REQUEST['uriseg']);

        $config['num_links'] = 5;
        $limit = 100;
        $config['per_page'] = $limit;
        $config['param'] = 'term=' . $term;


        if (check($_REQUEST['uriseg'])){
            $offset = $_REQUEST['uriseg'];
        }else{
            $offset = 0;
        }

        $config['total_rows'] = $this->users->get_count($term);
        $this->jquery_pagination->initialize($config);
        $data['curpage'] = ($offset / $limit) + 1;
        $data['countpages'] = ceil(($config['total_rows'] / $limit));

        //-----
        $data['users'] = $this->users->get_users($limit, $offset, $order, $term);

        $this->load->view('users/list_grid', $data);
    }

    public function itemTpl() {

        $data['cats'] = $this->users->get_cat_news();
        $code = $this->uri->segment(4);
        if ($code) {
            $data['arr'] = $this->users->get_user($code);
            $jobs = $this->users->getJobs($code);
            foreach ($jobs as $value) {
                $data['jobs'][] = $value['job_id'];
            }
        }

        $this->system_library->load('users/item_tpl', $data, TRUE);
    }

    function addItem() {
        $id = $this->input->post('id');
        $jobs = $this->input->post('job');
        if (!$id) {
            $id = $this->users->add_user();
        } else {
            $this->users->edit_user($id);
            $this->users->deleteJobs($id);
        }
        foreach ($jobs as $value) {
            $this->users->addJobs($id, $value);
        }

        $this->session->set_flashdata('message', 'تم الحفظ بنجاح');
        redirect('admin/users/listUser', 'refresh');
    }

    function edit_user() {
        $id = $this->uri->segment(4);
        $this->users->edit_user($id);
        $this->session->set_flashdata('message', 'تم التعديل بنجاح');
        redirect('admin/users/listUser', 'refresh');
    }

    public function deleteUser() {
        $id = $this->uri->segment(4);
        $this->users->delete_user($id);
        $this->news->deleteJob($id);
        $this->session->set_flashdata('message', 'تم الحذف بنجاح');
        redirect('admin/users/listUser', 'refresh');
    }

}

######### end class 

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */