<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Vedios extends MX_Controller {

    function __construct() {
        $this->lang->load('admin');
        $this->load->model('Vedios_model', 'vedios');
        $this->load->model('Langs_model', 'slang');
        // Check if the logged user is an administrator
        $this->access_library->check_access();
    }

############################### cats ################# 	

    public function showCats() {
        $mktba_id = $this->uri->segment(4);
        $data['mktba'] = $this->vedios->get_mktba($mktba_id);

        $data['arrs'] = $this->vedios->get_cats($mktba_id);
        $this->system_library->load('vedios/cats_list', $data, TRUE);
    }

    public function deleteCats() {
        $mktba_id = $this->uri->segment(5);
        $this->vedios->del_cats();
        $this->session->set_flashdata('message', 'تم الحذف بنجاح');
        redirect('admin/vedios/showCats/' . $mktba_id);
    }

    public function catsTpl() {
        $edit = $this->uri->segment(6);
        $data['langs'] = $this->slang->get_langs();
        $data['maxcode'] = $this->vedios->max_code('cats_code', 'cat_vedios');
        $data['cats'] = $this->vedios->get_cats($mktba_id);
        $code = $this->uri->segment(4);
        if ($edit) {
            $data['arr'] = $this->vedios->get_new($code);
            foreach ($data['arr'] as $arr) {
                $data['larr'][$arr['lang_abbr']] = $arr['title'];
                $data['darr'][$arr['lang_abbr']] = $arr['description'];
            }

            $data['maxcode'] = $data['arr'][0]['cats_code'];
            $data['mktba_id'] = $this->uri->segment(5);
        } else {
            $data['arr'] = array();
            $data['mktba_id'] = $this->uri->segment(4);
        }
        $data['mktba'] = $this->vedios->get_mktba($data['mktba_id']);
        $this->system_library->load('vedios/cats_tpl', $data, TRUE);
    }

    public function addCats() {
        $mktba_id = $this->input->post('mktba_id');
        $data['mktba'] = $this->vedios->get_mktba($mktba_id);

        $code = $this->input->post('code');
        $title = $this->input->post('title');
        $description = $this->input->post('description');
        $lang_abbr = $this->input->post('lang_abbr');

        if ($code != '') {
            $this->vedios->del_cats($code);
        }

        for ($i = 0; $i < count($lang_abbr); $i++) {
            $this->vedios->add_cats($lang_abbr[$i], $title[$i], $description[$i], $mktba_id);
        }

        $this->session->set_flashdata('message', 'تم الحفظ بنجاح');
        redirect('admin/vedios/showCats/' . $mktba_id);
    }

############################### items ################# 	

    public function showItems() {
        $mktba_id = $this->uri->segment(4);
        $data['mktba'] = $this->vedios->get_mktba($mktba_id);
        $data['cats'] = $this->vedios->get_cats($mktba_id);

        $this->system_library->load('vedios/item_list', $data, TRUE);
    }

    public function showItemsCats() {
        $mktba_id = $this->input->post('mktba_id');
        $data['mktba'] = $this->vedios->get_mktba($mktba_id);
        $cat_code = $this->input->post('item_cat_id');
        $data['arrs'] = $this->vedios->get_items($cat_code);

        $this->load->view('vedios/item_grid', $data);
    }

    public function deleteItem() {
        $mktba_id = $this->uri->segment(5);
        $this->vedios->del_item();
        $this->session->set_flashdata('message', 'تم الحذف بنجاح');
        redirect('admin/vedios/showItems/' . $mktba_id);
    }

    public function itemTpl() {


        $edit = $this->uri->segment(6);
        $data['langs'] = $this->slang->get_langs();
        $data['maxcode'] = $this->vedios->max_code('item_code', 'vedios');


        $data['larr'] = array();
        $data['darr'] = array();
        $code = $this->uri->segment(4);
        if ($edit) {
            $data['arr'] = $this->vedios->get_item($code);
            foreach ($data['arr'] as $arr) {
                $data['larr'][$arr['item_lang_abbr']] = $arr['item_name'];
                $data['darr'][$arr['item_lang_abbr']] = $arr['item_details'];

                $data['mktba_id'] = $this->uri->segment(5);
            }

            $data['maxcode'] = $data['arr'][0]['item_code'];
        } else {
            $data['arr'] = array();
            $data['mktba_id'] = $this->uri->segment(4);
        }

        $data['mktba'] = $this->vedios->get_mktba($data['mktba_id']);
        // $data['parent_cats'] = $this->vedios->get_cats($data['mktba_id'], array('parent_code != ' => 0));
        $data['parent_cats'] = $this->vedios->get_cats($data['mktba_id'], array('parent_code' => 0));
        $i = 0;
        foreach ($data['parent_cats'] as $parent_cat) {

            $data['parent_cats'][$i++]['cats'] = $this->vedios->get_cats($data['mktba_id'], array('parent_code' => $parent_cat['cats_code']));
        }
        //var_dump($data['parent_cats']);
        $data['cats'] = $this->getCats();
        //var_dump($this->getCats());
        $this->system_library->load('vedios/item_tpl', $data, TRUE);
    }

    //
    private function getCats($parent_code = 0) {
        $maktba_id = $this->uri->segment(4);
        $parent_cats = $this->vedios->get_cats($maktba_id, array('parent_code' => $parent_code));
        $i = 0;
        $category_data = array();
        foreach ($parent_cats as $result) {
            $category_data[] = array(
                'cats_code' => $result['cats_code'],
                'parent_code' => $result['parent_code'],
                'title' => $result['title'],
            );
            $category_data = array_merge($category_data, $this->getCats($result['cats_code']));
        }
        return $category_data;
        //var_dump($data['parent_cats']);
    }

    //
    public function addItem() {

        $mktba_id = $this->input->post('mktba_id');
        $code = $this->input->post('item_code');
        $item_name = $this->input->post('item_name');
        $item_details = $this->input->post('item_details');
        $lang_abbr = $this->input->post('lang_abbr');
        //var_dump($_POST);
        if ($code != '') {
            $this->vedios->del_item($code);
        }

        for ($i = 0; $i < count($lang_abbr); $i++) {
            $this->vedios->add_item($lang_abbr[$i], $item_name[$i], $item_details[$i]);
        }

        $this->session->set_flashdata('message', 'تم الحفظ بنجاح');
        redirect('admin/vedios/showItems/' . $mktba_id);
    }

}

######### end class 

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */