<?php

class Clients_model extends CI_Model {

    public function get_count($term) {
        $this->db->select('id');
        $this->db->where('id <>', '-1');
        if ($term) {
            // $this->db->like('username',$term);
            // $this->db->orlike('email',$term);
            // $this->db->orlike('display_name',$term);
        }
        $query = $this->db->count_all_results('clients');
        return $query;
    }

    // Public methods
    public function get_clients($active = 0) {
        $q = $this->input->post('search');
//        var_dump($q);exit;
        $this->db->select('*');
        if ($q) {
            $this->db->like('photo', $q);
        }
        $this->db->where('about_me', $active);
        $query = $this->db->get('clients');
        //echo $this->db->last_query();
        if ($query->num_rows() > 0) {
            return $query->result_array();
        }
    }

    public function get_user($id) {
        $this->db->select('*');
        $this->db->where('id', $id);

        $query = $this->db->get('clients', 1);
        //var_dump($query->row_array());
        if ($query->num_rows() == 1) {
            return $query->row_array();
        }
    }

    public function edit_user($id) {
        $data = array(
            'display_name' => $this->input->post('display_name'),
            'photo' => $this->input->post('name'),
            'username' => $this->input->post('user_name'),
            'about_me' => $this->input->post('about_me'),
            'serial' => $this->input->post('serial'),
            'model' => $this->input->post('model'),
            'details' => $this->input->post('details'),
            'item_photo' => $this->input->post('photohid'),
        );

        $this->db->where('id', $id);
        $this->db->update('clients', $data);
    }

    public function add_user() {
//        var_dump($_POST);exit;
        $data = array(
            'display_name' => $this->input->post('display_name'),
            'photo' => $this->input->post('name'),
            'username' => $this->input->post('user_name'),
            'about_me' => $this->input->post('about_me'),
            'serial' => $this->input->post('serial'),
            'model' => $this->input->post('model'),
            'details' => $this->input->post('details'),
            'item_photo' => $this->input->post('photohid'),
        );
        $this->db->insert('clients', $data);
        return $this->db->insert_id();
    }

    public function delete_user($id) {
        $this->db->where('id', $id);

        $this->db->delete('clients');
    }

################################### Projects #####################

    public function getProjects() {
        $client_id = $this->input->post('client');
        $search = $this->input->post('search');
        if ($client_id) {
            $this->db->where('client_id', $client_id);
        }
        if ($search) {
            $this->db->like('projectName', $search);
        }
        return $this->db->get('projects')->result_array();
    }

    public function getProject($id = '') {
        $this->db->where('id', $id);
        return $this->db->get('projects')->row_array();
    }

    public function addProject() {
        $data = array(
            "projectName" => $this->input->post('projectName'),
            "link" => $this->input->post('link'),
            "client_id" => $this->input->post('client_id'),
        );
        $this->db->insert('projects', $data);
    }

    public function editProject($id = '') {
        $data = array(
            "projectName" => $this->input->post('projectName'),
            "link" => $this->input->post('link'),
            "client_id" => $this->input->post('client_id'),
        );
        $this->db->where('id', $id);
        $this->db->update('projects', $data);
    }

    public function deleteProject($id = '') {
        $this->db->where('id', $id);
        $this->db->delete('projects');
    }

    public function deleteProjectClient($id = '') {
        $this->db->where('client_id', $id);
        $this->db->delete('projects');
    }

}

/* End of file clients_model.php */
/* Location: ./application/modules/admin/models/clients_model.php */