<?php

class Dashboard_model extends CI_Model {

    // Constructor
    public function __construct() {
        
    }

    // Public methods
    public function get_user($id) {
        $this->db->select('id, username, email, website, msn_messenger, jabber, display_name, about_me, registered, level');
        $this->db->where('id', $id);

        $query = $this->db->get('users', 1);

        if ($query->num_rows() == 1) {
            return $query->row_array();
        }
    }

    public function get_user_by_email($email) {
        $this->db->select('*');
        $this->db->where('email', $email);

        $query = $this->db->get('users', 1);

        if ($query->num_rows() == 1) {
            return $query->row_array();
        }
    }

    public function get_user_by_nickname($nickname) {
        $this->db->select('id, username, email, website, msn_messenger, jabber, display_name, about_me, registered, level');
        $this->db->where('username', $nickname);

        $query = $this->db->get('users', 1);

        if ($query->num_rows() == 1) {
            return $query->row_array();
        }
    }

    public function check_user($username, $password) {
        $this->db->select('id, username, level');
        $this->db->where('username', $username);
        $this->db->where('password', do_hash($password, 'md5'));
        $this->db->where('id', '-1');
        $this->db->where('status', '1');

        $query = $this->db->get('users', 1);

        if ($query->num_rows() == 1) {
            $row = $query->row_array();

            return $row['id'];
        } else {
            return FALSE;
        }
    }

    public function check_wordpress_password($username, $password) {

        $this->db->select('wordpress_password');
        $this->db->where('username', $username);
        $this->db->where('wordpress_password IS NOT NULL');
        $this->db->where('status', '1');

        $query = $this->db->get('users', 1);

        if ($query->num_rows() == 1) {
            $row = $query->row_array();
            $wordpress_password = $row['wordpress_password'];

            $check_password = $this->phpass_library->CheckPassword($password, $wordpress_password);

            return $check_password;
        } else {
            return FALSE;
        }
    }

    public function verify_user($username, $password) {
        $this->db->select('id, username, level, secret_key ,type');
        $this->db->where('username', $username);
        $this->db->where('password', do_hash($password, 'md5'));
        $this->db->where('status', '0');
        $this->db->where('level', '2');

        $query = $this->db->get('users', 1);

        if ($query->num_rows() == 1) {
            $row = $query->row_array();

            $data = array
                (
                'user_id' => $row['id'],
                'username' => $row['username'],
                'level' => $row['level'],
                'type' => $row['type'],
                'country' => $row['country'],
                'logged_in' => TRUE
            );
//            var_dump($data);exit;
            foreach ($data as $key => $val) {
                $_SESSION [$key] = $val;
            }
            $this->session->set_userdata($data);

            $this->clean_secret_key($row['id']);
        } else {
            $this->session->set_flashdata('message', 'خطأ في اسم المستخدم او كلمة المرور');
        }
    }

    public function update_last_login() {
        $data = array
            (
            'last_login' => date('Y-m-d H:i:s')
        );

        $this->db->where('id', $this->session->userdata('user_id'));
        $this->db->update('users', $data);
    }

    public function logout() {
        $data = array
            (
            'user_id' => 0,
            'username' => 0,
            'level' => 0,
            'type' => 0,
            'country' => 0,
            'logged_in' => 0
        );
        foreach ($data as $key => $val) {
            $_SESSION [$key] = $val;
        }
        $this->session->sess_destroy();
        $this->session->unset_userdata($data);
    }

    public function validation_check($data) {
        $this->db->select('id');
        $this->db->where($data);

        $query = $this->db->get('users');

        if ($query->num_rows() == 1) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function check_secret_key($key, $email) {
        $this->db->select('id');
        $this->db->where('secret_key', $key);
        $this->db->where('email', $email);

        $query = $this->db->get('users', 1);

        if ($query->num_rows() == 1) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function create_user() {
        $secret_key = do_hash(uniqid() + time(), 'md5');

        $data = array
            (
            'username' => $this->input->post('username'),
            'password' => do_hash($this->input->post('password'), 'md5'),
            'secret_key' => $secret_key,
            'display_name' => $this->input->post('display_name'),
            'email' => $this->input->post('email'),
            'website' => $this->input->post('website'),
            'msn_messenger' => $this->input->post('msn_messenger'),
            'jabber' => $this->input->post('jabber'),
            'about_me' => $this->input->post('about_me'),
            'registered' => date('Y-m-d H:i:s')
        );

        $this->db->insert('users', $data);

        $this->send_secret_key($this->input->post('email'), $secret_key, 'account_activation');
    }

    public function edit_profie($id) {
        $data = array
            (
            'display_name' => $this->input->post('display_name'),
            'email' => $this->input->post('email'),
            'website' => $this->input->post('website'),
            'msn_messenger' => $this->input->post('msn_messenger'),
            'jabber' => $this->input->post('jabber'),
            'about_me' => $this->input->post('about_me')
        );

        if ($this->input->post('password') != "") {
            $data['password'] = do_hash($this->input->post('password'), 'md5');
        }

        $this->db->where('id', $id);
        $this->db->update('users', $data);
    }

    public function forgotten_password() {
        $key = do_hash(uniqid() + time(), 'md5');

        $data = array
            (
            'secret_key' => $key
        );

        $this->db->where('username', $this->input->post('username'));
        $this->db->where('email', $this->input->post('email'));
        $this->db->update('users', $data);

        $this->send_secret_key($this->input->post('email'), $key, 'forgotten_password');
    }

    public function activate_account($key, $email) {
        $data = array
            (
            'secret_key' => '',
            'status' => '1'
        );

        $this->db->where('secret_key', $key);
        $this->db->where('email', $email);
        $this->db->update('users', $data);
    }

    public function reset_password($key, $email) {
        $new_password = random_string('alnum', 8);

        $data = array
            (
            'password' => do_hash($new_password, 'md5'),
            'secret_key' => ''
        );

        $this->db->where('secret_key', $key);
        $this->db->where('email', $email);
        $this->db->update('users', $data);

        $this->send_new_password($email, $new_password);
    }

    // Private or protected methods	
    protected function send_secret_key($email, $key, $type = 'account_activation') {
        $this->load->library('email');

        if ($type == 'account_activation') {
            $activation_url = account_activation_url($email, $key);

            $email_subject = lang('account_activation_subject');
            ;
            $email_body = lang('account_activation_body', array($activation_url, $activation_url));
            ;
        } else if ($type == 'forgotten_password') {
            $activation_url = forgotten_password_url($email, $key);

            $email_subject = lang('forgotten_password_subject');
            $email_body = lang('forgotten_password_body', array($activation_url, $activation_url));
        }

        $this->email->from($this->system_library->settings['admin_email'], $this->system_library->settings['blog_title']);
        $this->email->to($email);
        $this->email->subject($email_subject);
        $this->email->message($email_body);

        $this->email->send();
    }

    protected function send_new_password($email, $password) {
        $this->load->library('email');

        $login_url = site_url('user/login');

        $this->email->from($this->system_library->settings['admin_email'], $this->system_library->settings['blog_title']);
        $this->email->to($email);

        $this->email->subject(lang('new_password_subject'));
        $this->email->message(lang('new_password_body', array($password, $login_url)));

        $this->email->send();
    }

    protected function clean_secret_key($user_id) {
        $this->db->select('secret_key');
        $this->db->where('id', $user_id);

        $query = $this->db->get('users', 1);

        if ($query->num_rows() == 1) {
            $data = array
                (
                'secret_key' => ''
            );

            $this->db->where('id', $user_id);
            $this->db->update('users', $data);
        }
    }

    public function update_note() {
        $this->db->set('value', $this->input->post('admin_notes'));
        $this->db->where('name', 'admin_notes');
        $this->db->update('settings');
    }

    public function count_clients($active = 0) {
        $this->db->where('about_me', $active);
        return$this->db->count_all_results('clients');
    }

    public function count_tasks() {
        return$this->db->count_all_results('news');
    }

    public function count_users() {
        $wh = "id!=-1";
        $this->db->where($wh);
        return$this->db->count_all_results('users');
    }

    public function get_items() {
        $query = "select *,(select f_name_ar from users where users.id=photos.item_cat_id) AS worker from photos left JOIN languages ON photos.item_lang_abbr = languages.abbreviation where languages.is_default=1 and fa_end=0 or ff_end=0 GROUP BY photos.`item_code`";
        $query = $this->db->query($query);
        $result = $query->result_array();
        return $result;
    }

    public function get_client($id = '') {
        $sql = "select display_name,photo from clients where id='$id'";
        return $this->db->query($sql)->row_array();
    }

    public function update_password($id = '') {
        $this->db->where('id', $id);
        $data = array(
            "password" => md5($this->input->post('password'))
        );
        $this->db->update('users', $data);
    }

}

/* End of file user_model.php */
/* Location: ./application/modules/user/models/user_model.php */