<?php

class Users_model extends CI_Model {

    public function get_count($term) {
        $this->db->select('id');
        $this->db->where('id <>', '-1');
        if ($term) {
            // $this->db->like('username',$term);
            // $this->db->orlike('email',$term);
            // $this->db->orlike('display_name',$term);
        }
        $query = $this->db->count_all_results('users');
        return $query;
    }

    // Public methods
    public function get_users($number = 10, $offset = 0, $order = '', $term = '') {

        $sql = "select * from users where id!=-1";
        $this->db->where('id <>', '-1');
        if ($term) {
            $this->db->like('username', $term);
            $this->db->orlike('email', $term);
            $this->db->orlike('display_name', $term);
        }
        if ($order) {
            $this->db->order_by('degree', $order);
        } else {
            $this->db->order_by('id', 'desc');
        }
        $this->db->limit($number, $offset);
        $query = $this->db->query($sql);
        //echo $this->db->last_query();
        if ($query->num_rows() > 0) {
            return $query->result_array();
        }
    }

    public function get_user($id = '') {
        $sql = "select * from users where id='$id'";

        $query = $this->db->query($sql);
        //var_dump($query->row_array());
        if ($query->num_rows() == 1) {
            return $query->row_array();
        }
    }

    public function edit_user($id) {
        $data = array(
            'username' => $this->input->post('user_name'),
            'display_name' => $this->input->post('display_name'),
            'email' => $this->input->post('email'),
            'phone' => $this->input->post('phone'),
            'extraDetails' => $this->input->post('extraDetails'),
            'mobile' => $this->input->post('mobile'),
            'level' => 2,
            'type' => $this->input->post('type'),
            'status' => $this->input->post('status'),
            'skills' => $this->input->post('skills'),
        );
        if ($this->input->post('password') != "") {
            $data['password'] = do_hash($this->input->post('password'), 'md5');
        }
        $this->db->where('id', $id);
        $this->db->update('users', $data);
    }

    public function add_user() {

        $data = array(
            'username' => $this->input->post('user_name'),
            'display_name' => $this->input->post('display_name'),
            'email' => $this->input->post('email'),
            'phone' => $this->input->post('phone'),
            'extraDetails' => $this->input->post('extraDetails'),
            'mobile' => $this->input->post('mobile'),
            'type' => $this->input->post('type'),
            'level' => 2,
            'status' => $this->input->post('status'),
            'skills' => $this->input->post('skills'),
            'password' => do_hash($this->input->post('password'), 'md5'),
        );
        $this->db->insert('users', $data);
        return $this->db->insert_id();
    }

    public function delete_user($id) {
        $this->db->where('id', $id);

        $this->db->delete('users');
    }

    /* ######################### GRADUATES #################################### */

    public function getGraduate($id = 0) {
        $this->db->select('*');
        if (intval($id)) {
            $this->db->where('id', $id);
        }
        if (count($_POST)) {
            $this->db->like('name', $this->input->post('term'));
            $this->db->orlike('email', $this->input->post('term'));
            $this->db->orlike('mobile', $this->input->post('term'));
        }
        $this->db->order_by('id', 'desc');
        //$this->db->limit($number, $offset);	
        $query = $this->db->get('graduate');
        if ($query->num_rows() > 0) {
            return $query->result_array();
        }
    }

    //
    public function delete_graduate($id) {
        $this->db->where('id', $id);

        $this->db->delete('graduate');
    }

    public function get_clients($city = '') {
        $this->db->where('about_me', $city);
        return $this->db->get('clients')->result_array();
    }

    public function get_area() {
        return $this->db->get('country')->result_array();
    }

    public function get_cat_news() {
        $sql = "select *,(select title from cat_news cn2 where cn2.cats_code=cn.parent_code) AS parent_title from cat_news cn";
//        $this->db->where('lang_abbr',"ar");
        return $this->db->query($sql)->result_array();
    }

    public function addJobs($id = '', $jobId = '') {
        $jobParent = $this->db->query("select parent_code from cat_news where cats_code='$jobId'")->row_array();
        $data = array(
            "user_id" => $id,
            "job_id" => $jobId,
            "jobParent" => $jobParent['parent_code'],
        );
        $this->db->insert('jobs', $data);
    }

    public function deleteJobs($user_id = '') {
        $this->db->where('user_id', $user_id);
        $this->db->delete('jobs');
    }

    public function getJobs($user_id = '') {
        $this->db->where('user_id', $user_id);
        return $this->db->get('jobs')->result_array();
    }

    public function getUserId($parent_code = '') {
        $wh = '';
        $type = $this->input->post('type');
        if ($parent_code) {
            $wh = " and id=(select user_id from jobs where jobParent='$parent_code' limit 1) ";
        }
        $sql = "select id from users where type='$type' $wh";
        return $this->db->query($sql)->result_array();
    }

    /* ######################### END GRADUATES #################################### */
}

/* End of file users_model.php */
/* Location: ./application/modules/admin/models/users_model.php */