<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Access_library {

    // Constructor
    public function __construct() {
        if (!isset($this->CI)) {
            $this->CI = & get_instance();
        }
    }

    // Public methods
    public function is_logged_in() {
        if ($this->CI->session->userdata('logged_in') == TRUE) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function is_admin() {
        if ($this->CI->session->userdata('level') == '2') {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function check_logged_in() {
        if ($this->CI->session->userdata('logged_in') != TRUE) {
            redirect('user/login', 'refresh');
            exit();
        }
    }

    public function check_access() {
        // echo '<pre>';var_dump($_SESSION,$_SESSION);echo '</pre>';
        if ($this->CI->session->userdata('level') != '2') {
            redirect('admin', 'refresh');
            exit();
        }else{
            $type=$this->CI->session->userdata('type');
            $controller=$this->CI->router->fetch_class();
            $method=$this->CI->router->fetch_method();
            // echo '<pre>';var_dump($type,$controller,$method);echo '</pre>';
            if ($type==1&&(!in_array($controller,array('admin','news','setting'))||!in_array($method,array('logout','uploadphoto','uploadphoto2','uploadfile','dashboard','task','edit','update_password','update_task','settingTpl')))) {
                redirect('admin/dashboard', 'refresh');
                exit();
            }
        }
    }

}

/* End of file Access_library.php */
/* Location: ./application/libraries/Access_library.php */