<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Clients extends MX_Controller {

    function __construct() {
        $this->lang->load('admin');
        $this->load->model('Clients_model', 'clients');
        $this->load->model('News_model', 'news');
        // Check if the logged user is an administrator
        $this->access_library->check_access();
    }

    function listUser($order = 0) {
        //if($order=='asc'||$order=='desc'){
        $data['order'] = $order;
        //}
        $this->system_library->load('clients/list', $data, TRUE);
    }

    public function clients_show() {
        $_POST['client_id'] = $this->uri->segment(4);
        $data['arrs'] = $this->news->get_items();
        for ($i = 0; $i < count($data['arrs']); $i++) {
            $data['arrs']['tasks'][$i] = $this->news->get_task($data['arrs'][$i]['item_code']);
        }
        $this->system_library->load('clients/clients_show', $data, TRUE);
    }

    public function notifications() {
        $data['clients'] = $this->clients->get_clients(1);
        $this->system_library->load('clients/notifications', $data, TRUE);
    }

    public function showall($order = '', $term = '') {
//        var_dump($this->input->post('search'));exit;
        //-- paging ----
        if (!$term)
            $term = check($_REQUEST['term']);
        $config['base_url'] = site_url('admin/clients/showall');
        $data['order'] = $order;
        $config['div'] = 'tab1';
        $config['uriseg'] = check($_REQUEST['uriseg']);

        $config['num_links'] = 5;
        $limit = 100;
        $config['per_page'] = $limit;
        $config['param'] = 'term=' . $term;


        if (check($_REQUEST['uriseg']))
            $offset = $_REQUEST['uriseg'];
        else
            $offset = 0;

        $config['total_rows'] = $this->clients->get_count($term);
        $this->jquery_pagination->initialize($config);
        $data['curpage'] = ($offset / $limit) + 1;
        $data['countpages'] = ceil(($config['total_rows'] / $limit));

        //-----
        $data['clients'] = $this->clients->get_clients(0);
//        var_dump($data['clients']);exit;
        $this->load->view('clients/list_grid', $data);
    }

    public function itemTpl() {
        $data['area'] = $this->clients->get_area();
        $code = $this->uri->segment(4);
        if ($code) {
            $data['arr'] = $this->clients->get_user($code);
        }

        $this->system_library->load('clients/item_tpl', $data, TRUE);
    }

    function addItem() {
        $id = $this->input->post('id');
        if (!$id) {
            $_POST['item_user_id'] = $this->clients->add_user();
        } else {
            $this->clients->edit_user($id);
        }
        $this->session->set_flashdata('message', 'تم الحفظ بنجاح');
        redirect('admin/clients/listUser', 'refresh');
    }

    function edit_user() {
        $id = $this->uri->segment(4);
        $this->clients->edit_user($id);
        $this->session->set_flashdata('message', 'تم التعديل بنجاح');
        redirect('admin/clients/listUser', 'refresh');
    }

    public function deleteUser() {
        $id = $this->uri->segment(4);
        $task = $this->clients->get_items($id);
        foreach ($task as $value) {
            $this->clients->delete_task($value['item_code']);
            $this->clients->delete_news($value['item_code']);
        }
        $this->clients->deleteProject($id);
        $this->clients->delete_user($id);
        $this->session->set_flashdata('message', 'تم الحذف بنجاح');
        redirect('admin/clients/listUser', 'refresh');
    }

################################### Projects #####################

    public function showProjects() {
        $data['clients'] = $this->clients->get_clients();
        $this->system_library->load('clients/showProjects', $data, TRUE);
    }

    public function projectsGrid() {
        $data['projects'] = $this->clients->getProjects();
        $this->load->view('clients/projectsGrid', $data);
    }

    public function projectTpl() {
        $id = $this->uri->segment(4);
        $data['clients'] = $this->clients->get_clients();
        if ($id) {
            $data['arr'] = $this->clients->getProject($id);
        }
        $this->system_library->load('clients/projectTpl', $data, TRUE);
    }

    public function addProject() {
        $id = $this->input->post('id');
        if ($id) {
            $this->clients->editProject($id);
        } else {
            $this->clients->addProject();
        }
        $this->session->set_flashdata('message', 'تم الحفظ بنجاح');
        redirect('admin/clients/showProjects');
    }

    public function deleteProject() {
        $id = $this->uri->segment(4);
        $this->clients->deleteProject($id);
        $this->session->set_flashdata('message', 'تم الحذف بنجاح');
        redirect('admin/clients/showProjects');
    }

}

######### end class 

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */