<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Maillist extends MX_Controller {

    function __construct() {
        $this->lang->load('admin');
        $this->load->model('Maillist_model', 'maillist');
        $this->load->model('Langs_model', 'slang');
        // Check if the logged user is an administrator
        $this->access_library->check_access();
    }

############################### items ################# 	

    public function showItems() {

        $this->system_library->load('maillist/item_list', '', TRUE);
    }

    public function showall($term = '') {

        //-- paging ----
        if (!$term)
            $term = check($_REQUEST['term']);
        $config['base_url'] = site_url('admin/maillist/showall');

        $config['div'] = 'tab1';
        $config['uriseg'] = check($_REQUEST['uriseg']);

        $config['num_links'] = 5;
        $limit = 25;
        $config['per_page'] = $limit;
        $config['param'] = 'term=' . $term;


        if (check($_REQUEST['uriseg']))
            $offset = $_REQUEST['uriseg'];
        else
            $offset = 0;

        $config['total_rows'] = $this->maillist->get_count($term);
        $this->jquery_pagination->initialize($config);
        $data['curpage'] = ($offset / $limit) + 1;
        $data['countpages'] = ceil(($config['total_rows'] / $limit));

        //-----
        $data['arrs'] = $this->maillist->get_mails($limit, $offset, $term);

        $this->load->view('maillist/list_grid', $data);
    }

    public function deleteItem() {

        $this->maillist->del_item();
        $this->session->set_flashdata('message', 'تم الحذف بنجاح');
        redirect('admin/maillist/showItems');
    }

    public function itemTpl() {

        $this->system_library->load('maillist/item_tpl', '', TRUE);
    }

    function send() {
        $subject = $_REQUEST['title'];
        $message = $_REQUEST['details'];
        $mails = $this->maillist->get_allmails();
        foreach ($mails as $mail) {
            $email = $mail['mail_name'];
            $senderemail = $_REQUEST['senderemail'];
            $this->load->library('email');
            $this->email->from($senderemail, $this->system_library->settings['site_title']);
            $this->email->to($email);
            $this->email->subject($subject);
            $this->email->message($message);
            $this->email->send();
            //echo $email_body;
        }
        $this->session->set_flashdata('message', 'تم الارسال بنجاح');
        redirect('admin/maillist/showItems');
    }

    function exportmaillist() {
        $this->load->library('zip');

        $this->load->helper('download');
        $results = $this->maillist->get_allmails();

        foreach ($results as $email) {
            $data.=$email['mail_name'] . ",";
        }

        $file_name = 'maillist-' . date('Y-m-d') . '.txt';
        $this->zip->add_data($file_name, $data);
        $this->zip->download($file_name);
    }

}

######### end class 

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */