<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Pages extends MX_Controller {

    function __construct() {
        $this->lang->load('admin');
        $this->load->model('Pages_model', 'pages');
        $this->load->model('Langs_model', 'slang');
        // Check if the logged user is an administrator
        $this->access_library->check_access();
    }

############################### items ################# 	

    public function showItems() {
        $data['arrs'] = $this->pages->get_items();
        $this->system_library->load('pages/item_list', $data, TRUE);
    }

    public function deleteItem() {

        $this->pages->del_item();
        $this->session->set_flashdata('message', 'تم الحذف بنجاح');
        redirect('admin/pages/showItems');
    }

    public function itemTpl() {
        $data['langs'] = $this->slang->get_langs();
        $data['maxcode'] = $this->pages->max_code('item_code', 'pages');


        $data['larr'] = array();
        $data['darr'] = array();
        $code = $this->uri->segment(4);
        if ($code) {
            $data['arr'] = $this->pages->get_item($code);
            foreach ($data['arr'] as $arr) {
                $data['larr'][$arr['item_lang_abbr']] = $arr['item_name'];
                $data['darr'][$arr['item_lang_abbr']] = $arr['item_details'];
            }

            $data['maxcode'] = $data['arr'][0]['item_code'];
        } else
            
            $data['arr'] = array();
        $this->system_library->load('pages/item_tpl', $data, TRUE);
    }

  
     public function addItem() {

        $mktba_id = $this->input->post('mktba_id');


        $code = $this->input->post('item_code');
        $item_name = $this->input->post('item_name');
        $item_details = $this->input->post('item_details');
        $lang_abbr = $this->input->post('lang_abbr');

        if ($code != '') {
            $this->pages->del_item($code);
        }

        for ($i = 0; $i < count($lang_abbr); $i++) {
            $this->pages->add_item($lang_abbr[$i], $item_name[$i], $item_details[$i]);
        }
        //exit;
        $this->session->set_flashdata('message', 'تم الحفظ بنجاح');
        redirect('admin/pages/showItems/' . $mktba_id);
    }



}

######### end class 

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */