<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Phonelist extends MX_Controller
{
    
    function __construct() {
        $this->lang->load('admin');
        $this->load->model('Phonelist_model', 'phonelist');
        $this->load->model('Langs_model', 'slang');
        
        // Check if the logged user is an administrator
        $this->access_library->check_access();
    }
    
    //############################## items #################
    public function showItems() {
        
        $this->system_library->load('phonelist/item_list', '', TRUE);
    }
    
    public function showall($term = '') {
        
        //-- paging ----
        if (!$term) $term = check($_REQUEST['term']);
        $config['base_url'] = site_url('admin/phonelist/showall');
        
        $config['div'] = 'tab1';
        $config['uriseg'] = check($_REQUEST['uriseg']);
        
        $config['num_links'] = 5;
        $limit = 25;
        $config['per_page'] = $limit;
        $config['param'] = 'term=' . $term;
        
        if (check($_REQUEST['uriseg'])) $offset = $_REQUEST['uriseg'];
        else $offset = 0;
        
        $config['total_rows'] = $this->phonelist->get_count($term);
        $this->jquery_pagination->initialize($config);
        $data['curpage'] = ($offset / $limit) + 1;
        $data['countpages'] = ceil(($config['total_rows'] / $limit));
        
        //-----
        $data['arrs'] = $this->phonelist->get_phones($limit, $offset, $term);
        
        $this->load->view('phonelist/list_grid', $data);
    }
    
    public function deleteItem() {
        $this->phonelist->del_item();
        $this->session->set_flashdata('message', 'تم الحذف بنجاح');
        redirect('admin/phonelist/showItems');
    }
    
    public function itemTpl() {
        
        $this->system_library->load('phonelist/item_tpl', '', TRUE);
    }
    
    function send() {
    	//header("Content-Type: text/html; charset=utf-8");
        $message =  str_replace(' ','_',strip_tags($_REQUEST['message']));
        $phones = $this->phonelist->get_allphones();
        foreach ($phones as $phone) {
            $name = $phone['name'];
            $number = $phone['number'];

			$link="http://www.alrsael.com/api/sendsms.php?username=althager&password=kh123kh&numbers=".$number."&sender=ALTHAGER&unicode=e&message=".$message."&return=xml";
			//echo $link;
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $link);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER,3);
			$output = curl_exec($ch);
			//var_dump($output);// exit;
			curl_close($ch);
        }
        //exit;
        $this->session->set_flashdata('message', 'تم الارسال بنجاح');
        redirect('admin/phonelist/showItems');
    }
    
    function exportphonelist() {
        $this->load->library('zip');
        
        $this->load->helper('download');
        $results = $this->phonelist->get_allphones();
        
        foreach ($results as $ephone) {
            $data.= $ephone['name'] . "=>".$ephone['number']."\n\n";
        }
        
        $file_name = 'phonelist-' . date('Y-m-d') . '.txt';
        $this->zip->add_data($file_name, $data);
        $this->zip->download($file_name);
    }
}
 //######## end class

/* End of file welcome.php */

/* Location: ./application/controllers/welcome.php */
