<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Questions extends MX_Controller {
	function __construct() {
		$this->lang->load('admin');
		$this->load->model('Questions_model', 'questions');
		$this->load->model('Langs_model', 'slang');
		// Check if the logged user is an administrator
		$this->access_library->check_access();
	}
	############################### levels ################# 	
	public function showLevels(){
		$data['arrs'] = $this->questions->get_levels();
		$this->system_library->load('questions/levels_list', $data, TRUE);
	}	
	public function deleteLevels(){
		$this->questions->del_levels();
		$this->session->set_flashdata('message', 'تم الحذف بنجاح');
		redirect('admin/questions/showLevels/');
	}	
	public function levelsTpl($code=0,$edit=''){
		$data['langs'] = $this->slang->get_langs();
		$data['maxcode'] = $this->questions->max_code('cats_code','question_levels');
		//$code=$this->uri->segment(4);
		if($edit){
			$data['arr'] = $this->questions->get_level($code);
			foreach($data['arr'] as $arr){
				$data['larr'][$arr['lang_abbr']]=$arr['title'];
			}
			$data['maxcode']=$data['arr'][0]['cats_code'];
		}else{
			$data['arr']=array();
		}
		$this->system_library->load('questions/levels_tpl', $data, TRUE);
	}
	public function addLevels(){
		$code=$this->input->post('code');
		$title=$this->input->post('title');
		$lang_abbr=$this->input->post('lang_abbr');
		if($code!=''){
			$this->questions->del_levels($code);
		}
		for($i=0;$i<count($lang_abbr);$i++){ 
			$this->questions->add_levels($lang_abbr[$i],$title[$i]);
		} 
		$this->session->set_flashdata('message', 'تم الحفظ بنجاح');
		redirect('admin/questions/showLevels/');
	}	 
	############################### cats ################# 	
	public function showqCats(){
		$data['arrs'] = $this->questions->get_qcats();
		$this->system_library->load('questions/qcats_list', $data, TRUE);
	}	
	public function deleteqCats(){
		$this->questions->del_qcats();
		$this->session->set_flashdata('message', 'تم الحذف بنجاح');
		redirect('admin/questions/showqCats/');
	}	
	public function qcatsTpl($code=0,$edit=''){
		$data['langs'] = $this->slang->get_langs();
		$data['maxcode'] = $this->questions->max_code('cats_code','question_cats');
		//$code=$this->uri->segment(4);
		if($edit){
			$data['arr'] = $this->questions->get_qcat($code);
			foreach($data['arr'] as $arr){
				$data['larr'][$arr['lang_abbr']]=$arr['title'];
			}
			$data['maxcode']=$data['arr'][0]['cats_code'];
		}else{
			$data['arr']=array();
		}
		$this->system_library->load('questions/qcats_tpl', $data, TRUE);
	}
	public function addqCats(){
		$code=$this->input->post('code');
		$title=$this->input->post('title');
		$lang_abbr=$this->input->post('lang_abbr');
		if($code!=''){
			$this->questions->del_qcats($code);
		}
		for($i=0;$i<count($lang_abbr);$i++){ 
			$this->questions->add_qcats($lang_abbr[$i],$title[$i]);
		} 
		$this->session->set_flashdata('message', 'تم الحفظ بنجاح');
		redirect('admin/questions/showqCats/');
	}	 
	############################### cats ################# 	
	public function showCats(){
		$data['cats'] = $this->questions->get_qcats();
		$this->system_library->load('questions/cats_list', $data, TRUE);
	}
	public function showCatsGrid(){	
		$question_cat_id=$this->input->post('question_cat_id');
		$data['arrs'] = $this->questions->get_cats($question_cat_id);
		$this->load->view('questions/cats_grid', $data);
	}	
		
	public function deleteCats(){
		$this->questions->del_cats();
		$this->session->set_flashdata('message', 'تم الحذف بنجاح');
		redirect('admin/questions/showCats/');
	}	
	public function catsTpl($code=0,$edit=''){
		$data['langs'] = $this->slang->get_langs();
		$data['maxcode'] = $this->questions->max_code('cats_code','questions');
		$data['cats'] = $this->questions->get_qcats();
		$data['levels'] = $this->questions->get_levels();
		//$code=$this->uri->segment(4);
		if($edit){
			$data['arr'] = $this->questions->get_new($code);
			foreach($data['arr'] as $arr){
				$data['larr'][$arr['lang_abbr']]=$arr['title'];
				$data['darr'][$arr['lang_abbr']]=$arr['description'];
			}
			$data['maxcode']=$data['arr'][0]['cats_code'];
		}else{
			$data['arr']=array();
		}
		$this->system_library->load('questions/cats_tpl', $data, TRUE);
	}
	public function addCats(){
		$code=$this->input->post('code');
		$title=$this->input->post('title');
		$description = $this->input->post ( 'description' );
		$lang_abbr=$this->input->post('lang_abbr');
		if($code!=''){
			$this->questions->del_cats($code);
		}
		for($i=0;$i<count($lang_abbr);$i++){ 
			$this->questions->add_cats($lang_abbr[$i],$title[$i],$description[$i]);
		} 
		$this->session->set_flashdata('message', 'تم الحفظ بنجاح');
		redirect('admin/questions/showCats/');
	}	 
	############################### items ################# 	
	public function showItems(){
		$data['cats'] = $this->questions->get_cats();
		$this->system_library->load('questions/item_list', $data, TRUE);
	}
	public function showItemsCats(){	
		$cat_code=$this->input->post('item_cat_id');
		$data['arrs'] = $this->questions->get_items($cat_code);
		$this->load->view('questions/item_grid', $data);
	}	
	public function deleteItem(){
		$this->questions->del_item();
		$this->session->set_flashdata('message', 'تم الحذف بنجاح');
		redirect('admin/questions/showItems/');
	}	
	public function itemTpl(){
		$edit=$this->uri->segment(5);		
		$data['langs'] = $this->slang->get_langs();
		$data['maxcode'] = $this->questions->max_code('item_code','answers');
		$data['larr']=array();
		$data['darr']=array();
		$code=$this->uri->segment(4);
		if($edit){
			$data['arr'] = $this->questions->get_item($code);
			foreach($data['arr'] as $arr){
				$data['larr'][$arr['item_lang_abbr']]=$arr['item_name'];
			}
			$data['maxcode']=$data['arr'][0]['item_code'];
		}else{
			$data['arr']=array();
		}
		$data['cats'] = $this->questions->get_cats($data['mktba_id']);
		$this->system_library->load('questions/item_tpl', $data, TRUE);
	}
	public function addItem(){
		$code=$this->input->post('item_code');
		$item_name=$this->input->post('item_name');
		$lang_abbr=$this->input->post('lang_abbr');
		if($code!=''){
			$this->questions->del_item($code);
		}
		for($i=0;$i<count($lang_abbr);$i++){ 
			$this->questions->add_item($lang_abbr[$i],$item_name[$i]);
		}
		$this->session->set_flashdata('message', 'تم الحفظ بنجاح');
		redirect('admin/questions/showItems/');
	}
}######### end class 
/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */