<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Votes extends MX_Controller {
	function __construct() {
		$this->lang->load('admin');
		$this->load->model('Votes_model', 'votes');
		$this->load->model('Langs_model', 'slang');
		// Check if the logged user is an administrator
		$this->access_library->check_access();
	}
	/////////////////////
	public function showCats(){
		$data['arrs'] = $this->votes->get_cats();
		$this->system_library->load('votes/cats_list', $data, TRUE);
	}	

	function catsTpl(){
		$data['langs'] = $this->slang->get_langs();
		$data['maxcode'] = $this->votes->max_code('cats_code','votes');
		$code=$this->uri->segment(4);
		if($code){
			$data['arr'] = $this->votes->get_cat($code);
			$data['details'] = $this->votes->get_details($code);
			foreach($data['arr'] as $arr){
				$data['larr'][$arr['lang_abbr']]=$arr['title'];
			}
			$data['maxcode']=$data['arr'][0]['cats_code'];
		}else{
			$data['arr']=array();
		}
		$this->system_library->load('votes/cats_tpl',$data ,TRUE);
	}
	//
	public function addCats(){
		$code=$this->input->post('code');
		$title=$this->input->post('title');
		$voting_details=$this->input->post('voting_details');
		$lang_abbr=$this->input->post('lang_abbr');
		if($code!=''){
			$this->votes->del_cats($code);
		}
		for($i=0;$i<count($lang_abbr);$i++){
			$this->votes->add_cats($lang_abbr[$i],$title[$i],$voting_details,$code);
		}
		$this->session->set_flashdata('message', 'تم الحفظ بنجاح');
		redirect('admin/votes/showCats');
	}
	//
	public function deleteCats($code=''){
		$this->votes->del_cats($code);
		$this->session->set_flashdata('message', 'تم الحذف بنجاح');
		redirect('admin/votes/showCats');
	}
	//
	function showResult(){
		$data['langs'] = $this->slang->get_langs();
		$data['maxcode'] = $this->votes->max_code('cats_code','votes');
		$code=$this->uri->segment(4);
		if($code){
			$data['getvoting'] = $this->votes->get_cat($code);
			$data['details'] = $this->votes->get_details($code);
			$data['maxcode']=$data['arr'][0]['cats_code'];
		}else{
			$data['getvoting']=array();
			$data['details']=array();
		}
		$this->system_library->load('votes/show',$data ,TRUE);
	}
	//
}######### end class 
/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */